# coding: utf-8

from sandbox import sdk2
from sandbox.common import fs
from sandbox.common import os
from sandbox.projects.adfox.adfox_ui.metrics import AnalyzableTask

import sandbox.common.types.misc as ctm
import logging

BASE_REGISTRY_TAG = "partners/perl-backend"


class BuildDockerImagePartner(AnalyzableTask):
    checkout_path = 'partner2'
    name = 'BUILD_DOCKER_IMAGE_PARTNER'
    backend_image_name = BASE_REGISTRY_TAG

    class Requirements(sdk2.Task.Requirements):
        dns = ctm.DnsType.DNS64
        container_resource = 3113772271

    class Parameters(AnalyzableTask.Parameters):
        resource_id = sdk2.parameters.Integer(
            "Tarball resource_id",
            description="Tarball resource_id with partner docker content",
        )

        registry_tag = sdk2.parameters.String(
            "Docker tag",
            description="Docker tag",
        )

        docker_build_args = sdk2.parameters.String(
            "Additional args",
            description="Additional args",
        )

    def on_execute(self):
        resource_id = self.Parameters.resource_id
        resource = sdk2.Resource[resource_id]
        data = sdk2.ResourceData(resource)
        tarball_path = data.path  # See https://docs.python.org/dev/library/pathlib.html
        logging.info("Resource %d downloaded to %s", resource_id, tarball_path)

        self.suspend()

        untar_dir = os.path.realpath('docker')
        docker_dir_path = fs.untar_archive(tarball_path, untar_dir)
        logging.info('docker_dir_path {}'.format(docker_dir_path))

        os.chdir(untar_dir)
        self.exec_command("docker build . --tag {} --build-arg {}".format(
            self.Parameters.registry_tag,
            self.Parameters.docker_build_args
        ))

        self.exec_command("docker push {}".format(self.Parameters.registry_tag))

    def exec_command(self, command, logname='exec_log', cwd=None):
        with sdk2.helpers.ProcessLog(self, logger=logname) as process_log:
            return sdk2.helpers.subprocess.Popen(
                ('bash', '-c', command),
                stdout=process_log.stdout,
                stderr=process_log.stdout,
                cwd=cwd
            ).wait()
