#!/usr/bin/env bash

RAMDISK="/mnt/ramdisk"
if [ -d "${RAMDISK}" ]; then
    echo "Перенос базы данных в Ramdisk: ${RAMDISK}..."
    chown -R mysql:mysql "${RAMDISK}"

    DATA_OLD="/var/lib/mysql"
    DATA_NEW="${RAMDISK}/mysql"

    # переносим файлы
    [ -d "${DATA_NEW}" ] && rm -rf "${DATA_NEW}"
    cp -Rfp "${DATA_OLD}" "${RAMDISK}"

    # подправляем конфиг
    sed -i "s|${DATA_OLD}|${DATA_NEW}|g" /etc/mysql/mysql.conf.d/mysqld.cnf || true

    echo "Replace path $DATA_OLD to $DATA_NEW in the PI mysql config at /etc/mysql/my.cnf"
    sed -i "s|${DATA_OLD}|${DATA_NEW}|g" /etc/mysql/my.cnf || true
else
    echo "Ramdisk не подключен: ${RAMDISK} - пропускаем"
fi

# запускаем MySQL
/usr/sbin/mysqld
