#!/bin/bash


re="^(unstable|stable)$"

__usage="
Собирает и публикует бинарную задачу PARTNER_DOCKER_HERMIONE\n\n
Usage:\n
\t$0 \$type\n
Args:\n
\t\$type\tshould match $re
"

if [[ $1 =~ $re ]]; then
    ya make -d --target-platform=DEFAULT-LINUX-X86_64 &&
    ya upload ./docker_hermione \
        --sandbox \
        --transient \
        --type=SANDBOX_TASKS_BINARY \
        --arch=linux \
        --attr task_type=PARTNER_DOCKER_HERMIONE \
        --release=$1
else
    echo -e $__usage > /dev/stderr
    exit 1
fi

