# coding: utf-8

import logging

from sandbox import sdk2
from sandbox.common.types.misc import DnsType

from sandbox.projects.partner.settings import ROBOT_PARTNER_SECRET

from sandbox.projects.partner.utils.arc import Arc

from sandbox.projects.partner.tasks.misc.partner_front_task_base import PartnerFrontTaskBase

from sandbox.projects.partner.tasks.misc.arc import validate_branch


class FinishFrontend(PartnerFrontTaskBase):
    name = 'PARTNER_FINISH_FRONTEND'

    class Requirements(sdk2.Task.Requirements):
        dns = DnsType.DNS64

    class Parameters(PartnerFrontTaskBase.Parameters):
        description = 'Финализация версии фронта - создаем тег и пушим в Арканию'

        with sdk2.parameters.Group('Finalization') as main_section:
            arcadia_rc_branch = sdk2.parameters.String(
                'Релизная ветка',
                required=True,
                description='Релизная ветка на которой делался релиз/хотфикс',
            )
            frontend_version = sdk2.parameters.String(
                'Версия фронта',
                required=True,
                description='Версия фронтенда, полученная из BUILD_FRONTEND',
            )
        with sdk2.parameters.Group('Secrets') as secrets_section:
            arc_token = sdk2.parameters.YavSecret(
                'Arc OAuth token', description='Use arc to create release branch', default=ROBOT_PARTNER_SECRET
            )

    def get_arc_token(self):
        logging.debug('getting arc token')
        if not self.Parameters.arc_token:
            raise Exception('Arc access token is missed')

        token = self.Parameters.arc_token.data()['arc_token']
        logging.debug('success getting arc token')
        return token

    def get_yharnam_path(self, tag):
        return 'tags/releases/partner/yharnam/{}'.format(tag)

    def create_tag(self, tag_name):
        logging.info('Createing tag {}'.format(tag_name))
        self.arc.create_tag(tag_name)

    def push_tag(self, tag_name, path):
        logging.info('Push tag {tag_name} ti remote path {path}'.format(tag_name=tag_name, path=path))
        self.arc.push_tag(tag_name, path)

    def on_execute(self):
        """
        Push release tag to Arcadia
        """
        logging.debug('finish_frontend start')
        rc_branch = self.Parameters.arcadia_rc_branch.strip()
        if not validate_branch(rc_branch):
            logging.debug('{} is not a RC branch, leave'.format(rc_branch))
            return

        version = self.Parameters.frontend_version
        self.arc = Arc(path='.', token=self.get_arc_token())
        self.arc.checkout(rc_branch)

        self.create_tag(version)
        path = self.get_yharnam_path(version)
        self.push_tag(version, path)

        self.send_message('Релизный тэг pi_frontend: %s' % version)
        logging.debug('finish_frontend leave')
