import re

rc_regexp = r'releases/partner/PI-\d+-release-\d+'
user_regexp = r'^users\/[\w-]+\/[\w.-]+$'


def is_rc_branch(branch_name):
    return bool(re.match(rc_regexp, branch_name))


def validate_branch(branch_name):
    return bool(re.match(rc_regexp, branch_name)) or bool(re.match(user_regexp, branch_name)) or branch_name == 'trunk'
