import requests
import re

from sandbox import sdk2

from sandbox.projects.partner.settings import \
    OAUTH_VAULT_NAME, \
    OAUTH_VAULT_OWNER, \
    DOCKER_REGISTRY


class DockerRegistry:
    def __init__(self, oauth_token=None):
        token = sdk2.Vault.data(OAUTH_VAULT_OWNER, OAUTH_VAULT_NAME) if not oauth_token else oauth_token

        self.headers = {
            'Authorization': 'OAuth %s' % token,
            'Accept': 'application/vnd.docker.distribution.manifest.v2+json',
        }

    @staticmethod
    def get_request_url(package, resource):
        return 'https://%s/v2/%s/%s' % (DOCKER_REGISTRY, package, resource)

    def fetch(self, package, resource, method='GET'):
        return requests.request(
            method,
            self.get_request_url(package, resource),
            headers=self.headers
        )

    def check_package_exist(self, package, tag):
        resource = 'manifests/%s' % tag
        return self.fetch(package, resource).ok

    def tag_list(self, package, tag_filter=None):
        package = package.replace('%s/' % DOCKER_REGISTRY, '')
        resp = self.fetch(package, 'tags/list')
        tags = resp.json().get('tags', [])
        if tag_filter:
            tags = filter(lambda x: re.match(tag_filter, x), tags)
        return sorted(tags)
