# coding: utf-8

import re

BUILD_VERSION_RE = '\\d+\\.\\d+\\.\\d+'


def is_valid_version(version):
    """Провалидировать формат версии релизной сборки фронта ПИ"""
    version_re = '^%s$' % BUILD_VERSION_RE
    return re.match(version_re, version)


def is_rc_branch(git_ref):
    """
    Проверка соответствия имени ветки шаблону релиз-кандидата (RC) фронтенда.
    Любая такая ветка на фронте считается RC-веткой.
    RC-ветка (называемая также просто релизной) всегда отводится перед началом сборки
    релиза (или хотфикса) от заданной версии кода (верхушка ветки, тэг или явный хэш коммита )
    и далее накапливает любые изменения, внесенные в процессе выкладки (включая инкремент версии)
    """
    rc_like_re = '^(rc|hotfix)/%s$' % BUILD_VERSION_RE
    return bool(re.match(rc_like_re, git_ref))


def get_version_from_docker_tag(docker_tag):
    (ver, _) = docker_tag.split('_')
    if is_valid_version(ver):
        return ver
