from sandbox.projects.common.ya_deploy import release_integration
from sandbox import sdk2

import logging
import time
import tarfile
from cStringIO import StringIO
from sandbox.projects.deploy.CreateDeployDockerRelease import CreateDeployDockerRelease
from sandbox.projects.partner.tasks.misc.docker_registry import DockerRegistry


class PartnerOneshotRedeployResource(sdk2.Resource):
    any_arch = True
    auto_backup = False
    executable = False
    releasable = True


class PartnerRedeployOneshotStage(release_integration.ReleaseToYaDeployTask2, sdk2.Task):

    db_package = 'partners/partner2-db-general'
    YP_TOKEN_YAV_SECRET_ID = 'sec-01ctrdr10j7ejcnxak8wb3k5d1'
    YP_TOKEN_YAV_SECRET_KEY = 'dctl_yp_token'

    @property
    def release_template(self):
        return sdk2.ReleaseTemplate()

    def get_yp_oauth_token(self):
        return sdk2.yav.Secret(self.YP_TOKEN_YAV_SECRET_ID).data()[self.YP_TOKEN_YAV_SECRET_KEY]

    def on_execute(self):
        # Release task for DB
        release_task = CreateDeployDockerRelease(
            self,
            description="Deploy oneshot stage. Child of task {}".format(self.id),
            create_sub_task=False
        )
        docker_registry = DockerRegistry()
        tag_list = docker_registry.tag_list(self.db_package, r'^\d\.\d{2}\.\d{4}-\d{4}-\d{2}-\d{2}$')
        if len(tag_list) == 0:
            raise Exception('Cannot find tags for %s' % self.db_package)

        images = ['%s:%s' % (self.db_package, tag_list[-1])]

        release_task.Parameters.yp_token_yav_secret = self.YP_TOKEN_YAV_SECRET_ID
        release_task.Parameters.yp_token_yav_secret_key = self.YP_TOKEN_YAV_SECRET_KEY
        release_task.Parameters.release_type = 'testing'
        release_task.Parameters.docker_images = images
        self.Context.release_task = release_task.save().enqueue().id
        logging.debug('Task created %s' % self.Context.release_task)

        # Creating resource with just time
        layer_data = "Last update: {}".format(time.time())
        layer = sdk2.ResourceData(PartnerOneshotRedeployResource(self, "Updater", "updater.tar.gz"))
        layer_io = StringIO()
        with tarfile.open(fileobj=layer_io, mode="w:gz") as tar:
            info = tarfile.TarInfo("updater.txt")
            info.size = len(layer_data)
            tar.addfile(info, fileobj=StringIO(layer_data))
        layer.path.write_bytes(layer_io.getvalue())
        layer.ready()
        self.on_release({'release_status': 'testing', 'email_notifications': {'cc': [], 'to': []}})
