# coding: utf-8

import logging
import time

from sandbox import sdk2
import sandbox.common.types.misc as ctm

from sandbox.projects.partner.tasks.misc.partner_front_task_base import Callbackable
from sandbox.projects.partner.resources import PartnerFrontLxc


class PartnerSquare(sdk2.Task, Callbackable):
    """
    Area for running tech experiments
    """

    name = 'PARTNER_SQUARE'

    class Parameters(Callbackable.Parameters):
        pass

    class Requirements(sdk2.Task.Requirements):
        dns = ctm.DnsType.DNS64
        container_resource = sdk2.parameters.Container(
            resource_type=PartnerFrontLxc,
            required=True
        )

    class Context(sdk2.Task.Context):
        now = time.time()

    def get_callback_headers(self):
        headers = Callbackable.get_callback_headers(self)
        headers['host'] = 'krush.partner.yandex-team.ru'
        return headers

    def on_execute(self):
        logging.debug('on_execute enter at %f', self.Context.now)
        Callbackable.send_message(self, self.Parameters.description)
        logging.debug('on_execute leave now %f', time.time())
