# -*- coding: utf-8 -*-

import os

from sandbox import sdk2
from sandbox.projects.partner.settings import ROBOT_PARTNER_SECRET
from sandbox.projects.partner.tasks.tanker_sync import TankerSync


class JavaTankerSync(TankerSync):
    name = 'PARTNER_JAVA_TANKER_SYNC'

    class Parameters(TankerSync.Parameters):
        ya_token = sdk2.parameters.YavSecret(
            'YA token',
            description='Use ya token for enable yt cache',
            default='{}#ya_token'.format(ROBOT_PARTNER_SECRET),
            required=True,
        )

    def get_language(self):
        return 'java'

    def update_and_add_to_stage(self, arc):
        root = str(sdk2.task.Task.current.path())
        src_path = os.path.join(root, 'arc', 'arcadia', 'partner', 'java', 'apps', 'jsonapi')

        # В PATH добавляем путь для запуска ya и запускаем скрипт
        env = os.environ.copy()
        env['PATH'] = '{}:{}'.format(arc.path, env['PATH'])
        env['YA_TOKEN'] = self.Parameters.ya_token.value()
        self._execute(command=['./tanker-sync.sh'], path=src_path, env=env)

        path_to_translations = os.path.join(src_path, 'src', 'main', 'resources', 'translations')
        self._execute([arc.arc_binary, 'add', path_to_translations], arc.path)
