# -*- coding: utf-8 -*-

import logging
import os
import shutil

from sandbox import sdk2

from sandbox.projects.partner.settings import ROBOT_PARTNER_SECRET, PI_LXC_WITH_DOCKER
from sandbox.projects.partner.tasks.tanker_sync import TankerSync
from sandbox.projects.partner.utils.docker import docker_login, docker_logout


class PerlTankerSync(TankerSync):
    name = 'PARTNER_PERL_TANKER_SYNC'

    class Requirements(TankerSync.Requirements):
        container_resource = PI_LXC_WITH_DOCKER

    class Parameters(TankerSync.Parameters):
        docker_token = sdk2.parameters.YavSecret(
            'Docker Registry OAuth token',
            description='Use docker for execute script',
            default='{}#docker_token'.format(ROBOT_PARTNER_SECRET),
            required=True,
        )

    def get_language(self):
        return 'perl'

    def update_and_add_to_stage(self, arc):
        self._update_locale(arc, str(sdk2.task.Task.current.path()), self.suffix)

    def _update_locale(self, arc, root_path, suffix):
        export_path = os.path.join(root_path, 'arc_export_{}'.format(suffix))
        os.mkdir(export_path)
        arc.export(export_path, self.Parameters.arc_branch, 'partner/perl/partner2')
        export_src_path = os.path.join(export_path, 'partner', 'perl', 'partner2')
        base_tag_filepath = os.path.join(export_src_path, 'configs', 'default', 'bionic', 'base_docker_tag')
        logging.debug('Read base tag from {}'.format(base_tag_filepath))

        with open(base_tag_filepath, 'r') as f:
            base_tag = f.read().strip()

        docker_login('robot-partner', self.Parameters.docker_token.value())
        try:
            self._execute_with_retries(
                ['docker', 'run', '--rm', '--network', 'host', '-v', '{}:/usr/share/partners2'.format(export_src_path),
                 'registry.yandex.net/partners/perl-backend-base-bionic:{}'.format(base_tag),
                 '/usr/share/partners2/bin/download_tanker.py'], root_path
            )
        finally:
            docker_logout()

        arc_path = os.path.join(arc.path, 'partner', 'perl', 'partner2')
        arc_locale_path = os.path.join(arc_path, 'locale')
        export_locale_path = os.path.join(export_src_path, 'locale')
        shutil.rmtree(arc_locale_path)
        shutil.copytree(src=export_locale_path, dst=arc_locale_path)
        self._execute([arc.arc_binary, 'add', arc_locale_path], arc_locale_path)
