# -*- coding: utf-8 -*-
from sandbox.projects.partner.tasks.misc.partner_front_task_base import NotificationLevels


def send_tests_result_message(send_message, name, report_data, task_id, is_error=False):
    result = 'неудачно' if is_error else 'успешно'

    send_message(
        'Тесты {} завершились {}'.format(name, result)
        + '\nВсего: {}\nПройдено: {} ({}%)\nПровалено: {}\nПропущено: {}\nПерезапущено: {}\n'.format(
            report_data.get('total', 0),
            report_data.get('passed', 0),
            report_data.get('passed_percent', 0),
            report_data.get('failed', 0),
            report_data.get('skipped', 0),
            report_data.get('retries', 0)
        )
        + 'https://sandbox.yandex-team.ru/task/{}'.format(task_id),
        NotificationLevels.URGENT
    )
