# coding: utf-8

import logging
import subprocess as sp
import time


def docker_login(username, token, registry='registry.yandex.net', tries=3):
    logging.info('Docker login. Username={}, registry={}'.format(username, registry))

    for i in range(1, tries + 1):
        command = ['docker', 'login', '-u', username, '--password-stdin', registry]
        process = sp.Popen(args=command, stdin=sp.PIPE, stdout=sp.PIPE, stderr=sp.PIPE, universal_newlines=True)

        logging.debug('Execute: {}'.format(command))

        out, err = process.communicate(input=token)
        return_code = process.returncode

        logging.debug('return_code')
        logging.debug(return_code)
        logging.debug('out')
        logging.debug(out)
        logging.debug('err')
        logging.debug(err)

        if return_code > 0:
            logging.warning('Failed try {} of {}', i, tries)
            time.sleep(5)
        elif i == tries:
            raise Exception('ErrCode: {}. ErrMessage: {}. Failed command {}'.format(return_code, err, command))
        else:
            return out, err


def docker_build(path, tag, build_args=None, docker_file='Dockerfile'):
    command = ['docker', 'build', '.', '--file', docker_file, '--tag', tag]

    if build_args is not None:
        for build_arg in build_args:
            command.append('--build-arg')
            command.append(build_arg)

    return _execute(command=command, cwd=path)


def docker_push(tag):
    command = ['docker', 'push', tag]
    return _execute(command=command)


def docker_logout():
    logging.info('Docker logout')
    command = ['docker', 'logout']
    return _execute(command=command)


def _execute(command, cwd=None):
    logging.debug('Execute: {}'.format(command))
    process = sp.Popen(command, cwd=cwd, stdout=sp.PIPE, stderr=sp.PIPE)
    out, err = process.communicate()

    return_code = process.returncode
    logging.debug('return_code')
    logging.debug(return_code)
    logging.debug('out')
    logging.debug(out)
    logging.debug('err')
    logging.debug(err)

    if return_code > 0:
        raise Exception('ErrCode: {}. ErrMessage: {}. Failed command {}'.format(return_code, err, process.args))

    return out, err
