#!/usr/bin/env python3

from sandbox.projects.partner.tasks.misc import configure_internal_ca
import json
import requests

PRODUCTION_VERSION_JSON_URL = 'https://partner.yandex-team.ru/partner2_production_version.json'


class VersionType:
    FRONTEND = 'f'
    PERL = 's'
    JAVA = 'j'


def get_production_tag(version_type):
    return _get_all_production_tags()[version_type]


def _get_all_production_tags():
    configure_internal_ca()
    prod_version_json = requests.get(PRODUCTION_VERSION_JSON_URL).text
    return json.loads(prod_version_json)
