# coding: utf-8

from sandbox import sdk2
from sandbox.projects.sandbox_ci.resources import SANDBOX_CI_ARTIFACT


STATUSES_CLASSES = {
    'ASSIGNED': 'status_executing',
    'EXECUTING': 'status_executing',
    'RUNNING': 'status_executing',
    'SUCCESS': 'status_success',
    'FAILURE': 'status_exception',
    'EXCEPTION': 'status_exception',
    'UNKNOWN': 'status_draft'
}


def get_artifact_publish_data(artifact_id):
    resource = sdk2.Resource[artifact_id]
    return dict(
        description=resource.description,
        url=resource.http_proxy
    )


class SandboxReporter:
    def __init__(self, task):
        self.artifacts = task.Context.reporter_artifacts or list()
        self.task = task

    @property
    def has_result(self):
        return bool(self.task.Context.reporter_artifacts)

    def get_artifacts_for_template(self):
        artifacts = self.task.Context.reporter_artifacts
        if not artifacts:
            return list()

        return [
            get_artifact_publish_data(aid) for aid in artifacts
        ]

    def save_context(self):
        self.task.Context.reporter_artifacts = self.artifacts
        self.task.Context.save()

    def save_report(self, path, description, **attrs):
        report = SANDBOX_CI_ARTIFACT(
            self.task,
            description,
            path=path,
            **attrs
        )
        sdk2.ResourceData(report).ready()
        self.artifacts.append(report.id)
        self.save_context()
