# -*- coding: utf-8 -*-
import os
import shutil
from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
import sandbox.common.types.client as ctc


GIT_REPO = 'https://github.yandex-team.ru/passport/pocket-service.git'


class PASSPORT_POCKET_SERVICE(sdk2.Resource):
    """Релиз passport-pocket-service"""
    releasers = ["kmerenkov"]
    releasable = True
    any_arch = False
    executable = False


class BuildPassportPocketService(sdk2.Task):
    """Builds environment for passport-pocket-service."""

    class Requirements(sdk2.Task.Requirements):
        privileged = True
        client_tags = ctc.Tag.LINUX_PRECISE

    class Parameters(sdk2.Task.Parameters):
        git_tag = sdk2.parameters.String('git tag', default='master', required=True)

    def git_clone(self, url, target, tag):
        with sdk2.helpers.ProcessLog(self, logger='git_clone') as pl:
            sp.check_call(['git', 'clone', url, target], stdout=pl.stdout, stderr=sp.STDOUT)
            os.chdir(target)
            sp.check_call(['git', 'checkout', tag], stdout=pl.stdout, stderr=sp.STDOUT)
            os.chdir('..')

    def on_execute(self):
        shutil.rmtree('git_checkout', True)

        tag = self.Parameters.git_tag
        self.git_clone(GIT_REPO, 'git_checkout', tag)
        os.chdir('git_checkout')
        with sdk2.helpers.ProcessLog(self, logger='make') as pl:
            sp.check_call(['make', 'init'], stdout=pl.stdout, stderr=sp.STDOUT)

        os.chdir('..')

        out_fname = 'passport_pocket_service_build.tar.gz'
        shutil.move('git_checkout/build.tar.gz', out_fname)
        PASSPORT_POCKET_SERVICE(
            self,
            description='passport-pocket-service release {tag}'.format(tag=tag),
            path=out_fname,
        )

        shutil.rmtree('git_checkout', True)
