# coding: utf-8
import datetime

from sandbox import sdk2


TIME_FORMAT = '%Y-%m-%d'


class PassportLbcbckRecompression(sdk2.Task):
    """
    Пережимает таблицы для lbcbck из lz4 в brotli8
    PASSP-29254
    """

    class Parameters(sdk2.Parameters):

        with sdk2.parameters.Group("Yav settings") as yav_settings:
            secret = sdk2.parameters.YavSecret(
                "secret id",
                required=True,
            )
            secret_key = sdk2.parameters.String(
                "key in yav secret",
                required=True,
            )

        with sdk2.parameters.Group("Common settings") as common_settings:
            retries = sdk2.parameters.Integer(
                "retries",
                default=3,
                required=True,
            )
            date_offset = sdk2.parameters.Integer(
                "date offset (0 to disable) (conflicts with 'date')",
                default=-7,
            )
            date = sdk2.parameters.String(
                "date (%s) (conflicts with 'date offset')" % TIME_FORMAT,
                default='',
            )

    def on_execute(self):
        oauth_token = self.Parameters.secret.data()[self.Parameters.secret_key]
        assert len(oauth_token) > 0

        retries = self.Parameters.retries
        assert self.Parameters.retries >= 1

        date = self._check_date()

        from sandbox.projects.passport.lbcbck_recompression.lib.recompression import run

        run(date=date, oauth_token=oauth_token, retries=retries)

    def _check_date(self):
        date_offset = self.Parameters.date_offset or 0
        date = self.Parameters.date or ''

        if date_offset == 0:
            assert date != ''
            return datetime.datetime.strptime(date, TIME_FORMAT).date()
        else:
            assert date == '', 'got "%s"' % date
            assert date_offset < 0
            return (datetime.datetime.now() + datetime.timedelta(days=date_offset)).date()
