import argparse

from sandbox.projects.passport.logfeller_drop_rows.lib.drop_rows import run

if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='drop logfeller rows')
    parser.add_argument('logtype', type=str, help='logtype (blackbox-log|oauth-log)')
    parser.add_argument('table', type=str, help='table (example: 1d/2022-12-06)')
    parser.add_argument('yql_token', type=str, help='oauth token with scopes for YQL')
    parser.add_argument('nirvana_token', type=str, help='oauth token with scopes for Nirvana')
    parser.add_argument('mark_ext_bin_path', type=str, help='path to logfeller_mark_external_logs binary')
    parser.add_argument('--retries', type=int, default=3, help='retries')
    args = parser.parse_args()

    assert args.retries >= 1

    run(
        logtype=args.logtype,
        table=args.table,
        yql_token=args.yql_token,
        nirvana_token=args.nirvana_token,
        retries=args.retries,
        mark_ext_bin_path=args.mark_ext_bin_path,
    )
