# -*- coding: utf-8 -*-
import os
import shutil

from sandbox import sdk2
from sandbox.projects.common.build.YaMake2 import YaMake2


TVMAUTH_CACHE_DIR = '/tmp/passport/autotests/%s/tvm_cache/' % os.environ.get('USER', 'default')


class SecretIdParameter(sdk2.parameters.String):
    name = 'Secret ID'
    description = 'Secret ID (with secrets for tests) in vault.yandex-team.ru (sec-XXX)'
    required = True


class PassportAutotestsYaMake2(YaMake2):
    class Parameters(YaMake2.Parameters):
        secret_id = SecretIdParameter()

    def pre_execute(self):
        super(PassportAutotestsYaMake2, self).pre_execute()

        # Создаём временную директорию для кэша tvmauth
        try:
            os.makedirs(TVMAUTH_CACHE_DIR)
        except OSError:
            pass  # уже существует

        # Кладём секреты в переменные окружения
        secret_data = sdk2.yav.Secret(self.Parameters.secret_id).data()
        for key, value in secret_data.items():
            os.environ['PASSPORT_AUTOTESTS_%s' % key.upper()] = value

    def post_build(self, *args, **kwargs):
        super(PassportAutotestsYaMake2, self).post_build(*args, **kwargs)

        # Удаляем полученные TVM-тикеты
        shutil.rmtree(TVMAUTH_CACHE_DIR, ignore_errors=True)
