# coding: utf-8
from sandbox import sdk2
import sandbox.common.types.notification as ctn
from sandbox.projects.common.geosearch.startrek import StartrekClient
from sandbox.projects.tank.LoadTestResults import LoadTestResults
from sandbox.projects.tank.LoadTestResults.loadtest_report import ReportLoadTestResults
from sandbox.projects.tank.lunapark_client.settings import LUNAPARK_URL


def create_report(shoot_id, report_type):
    report = ReportLoadTestResults(shoot_id, report_type)
    report.get_summary()
    report.build_message()
    return report


class PassportSendShootingReport(LoadTestResults):

    class Parameters(LoadTestResults.Parameters):
        report_title = sdk2.parameters.String(
            'Report title',
        )

    def on_execute(self):
        report = create_report(self.Parameters.shoot_id, self.Parameters.report_type)
        message = report.message

        is_ok = report.check_resolution()
        status = 'OK' if is_ok else 'FAIL'
        default_title = 'Results for %s/%s' % (LUNAPARK_URL, self.Parameters.shoot_id)
        title = '<%s> %s' % (status, self.Parameters.report_title or default_title)

        if self.Parameters.send_comment:
            st_client = StartrekClient(
                oauth_token=sdk2.Vault.data(self.Parameters.st_token_name),
            )
            comment_text = '%s\n\n%s' % (title, message)
            st_client.add_comment(self.Parameters.ticket_id, comment_text)

        if self.Parameters.send_letter:
            self.server.notification(
                subject=title,
                body=message,
                recipients=self.Parameters.mail_recipients,
                transport=ctn.Transport.EMAIL,
            )
