# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.projects.resource_types import releasers as resource_releasers


class YA_PACKAGE_PASSPORT(sdk2.resource.AbstractResource):
    """
        Resource ya package for Passport
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.experiment_releasers + [
        'cerevra',
        'karganov',
        'dyor',
        'kmerenkov',
        'eugene311',
        'ppodolsky',
    ]


class PASSPORT_API_PACKAGE(sdk2.resource.AbstractResource):
    """
    Passport API YA_PACKAGE
    """
    auto_backup = True
    releasable = True
    releasers = [
        'robot-srch-releaser',
        'robot-testenv',
        'kmerenkov',
        'eugene311',
    ]


class PASSPORT_DBSCRIPTS_PACKAGE(sdk2.resource.AbstractResource):
    """
    Passport db-scripts YA_PACKAGE
    """
    auto_backup = True
    releasable = True
    releasers = [
        'robot-srch-releaser',
        'robot-testenv',
        'kmerenkov',
        'eugene311',
    ]


class PASSPORT_POCKET_SERVICE_PACKAGE(sdk2.resource.AbstractResource):
    """
    Passport pocket-service YA_PACKAGE
    """
    releasable = True
    releasers = [
        'robot-passport-ci',
        'robot-passport-test',
        'kmerenkov',
        'eugene311',
        'gladnik',
    ]


class PASSPORT_QA_PROXY_PACKAGE(sdk2.resource.AbstractResource):
    """
    passport-qa-proxy YA_PACKAGE
    """
    auto_backup = True
    releasable = True
    releasers = [
        'robot-passport-ci',
        'robot-passport-test',
        'kmerenkov',
        'eugene311',
        'gladnik',
    ]


class PASSPORT_UAAS_PROXY_DEPLOY_PACKAGE(sdk2.resource.AbstractResource):
    """
    passport-uaas-proxy YA_PACKAGE
    """
    auto_backup = True
    releasable = True
    releasers = [
        'robot-passport-ci',
        'robot-srch-releaser',
        'robot-testenv',
        'kmerenkov',
        'eugene311',
    ]


class PASSPORT_SCIM_API_DEPLOY_PACKAGE(sdk2.resource.AbstractResource):
    """"
    passport-scim-api YA_PACKAGE
    """
    auto_backup = True
    releasable = True
    releasers = [
        'robot-passport-ci',
        'robot-srch-releaser',
        'robot-testenv',
        'kmerenkov',
        'eugene311',
    ]


class PASSPORT_FEDERAL_CONFIG_API_DEPLOY_PACKAGE(sdk2.resource.AbstractResource):
    """"
    passport-federal-config YA_PACKAGE
    """
    auto_backup = True
    releasable = True
    releasers = [
        'robot-passport-ci',
        'robot-srch-releaser',
        'robot-testenv',
        'kmerenkov',
        'eugene311',
    ]


class PASSPORT_PY_ADM_DEPLOY_PACKAGE(sdk2.resource.AbstractResource):
    """"
    passport-py-adm YA_PACKAGE
    """
    auto_backup = True
    releasable = True
    releasers = [
        'robot-passport-ci',
        'robot-srch-releaser',
        'robot-testenv',
        'kmerenkov',
        'eugene311',
        'kanavis',
    ]


class PORTO_LAYER_DEPLOY_TVMTOOL(sdk2.Resource):
    """
    Porto layer for tvmtool in Y.Deploy
    """

    auto_backup = True


class BASE_SOCIAL_PACKAGE(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = [
        'andrey1931',
        'kmerenkov',
        'robot-srch-releaser',
        'robot-testenv',
    ]


class SOCIAL_API_PACKAGE(BASE_SOCIAL_PACKAGE):
    """
    Social API YA_PACKAGE
    """


class SOCIAL_BROKER_PACKAGE(BASE_SOCIAL_PACKAGE):
    """
    Social Broker YA_PACKAGE
    """


class SOCIAL_PROXY2_PACKAGE(BASE_SOCIAL_PACKAGE):
    """
    Social Porxy2 YA_PACKAGE
    """


class SOCIAL_UTILS_PACKAGE(BASE_SOCIAL_PACKAGE):
    """
    Social Utils YA_PACKAGE
    """


class SOCIAL_UTILS_CELERYBEAT_PACKAGE(BASE_SOCIAL_PACKAGE):
    """
    Social Utils Celerybeat YA_PACKAGE
    """


class SOCIAL_UTILS_DUMPERS_PACKAGE(BASE_SOCIAL_PACKAGE):
    """
    Social Utils Dumpers YA_PACKAGE
    """


class SOCIAL_CONFIGS_PACKAGE(BASE_SOCIAL_PACKAGE):
    """
    Social Configs YA_PACKAGE
    """


class SOCIAL_METRICS_PACKAGE(BASE_SOCIAL_PACKAGE):
    """
    Social Metrics YA_PACKAGE
    """


class SOCIAL_NGINX_PACKAGE(BASE_SOCIAL_PACKAGE):
    """
    Social Nginx YA_PACKAGE
    """


class SOCIAL_SECRETS_YAV_PACKAGE(BASE_SOCIAL_PACKAGE):
    """
    Social Secrets YA_PACKAGE
    """
