import os
import shutil
from sandbox import sdk2
from sandbox import common
from sandbox.projects.BuildDockerImageFromGit import BuildDockerImageFromGit
from sandbox.projects.BuildDockerImageFromGit import DockerContentResourse
from sandbox.projects.paysys.tasks.docker.PaysysBuildDockerImageFromGit.helpers import run_shell_get_output
from sandbox.projects.paysys.lib.docker.main import PaysysDockerDummyResource


class PaysysBuildDockerImageFromGitParameters(
        BuildDockerImageFromGit.Parameters):
    docker_registry_parent_image = sdk2.parameters.String(
        "Docker registry parent image", required=True,
    )


class PaysysBuildDockerImageFromGit(BuildDockerImageFromGit):
    class Requirements(BuildDockerImageFromGit.Requirements):
        disk_space = 2048
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(PaysysBuildDockerImageFromGitParameters):
        pass

    def _get_git_latest_commit(self):
        out, err, retcode = run_shell_get_output(
            "git rev-parse HEAD",
            cwd=self.checkout_path,
        )

        if err or retcode:
            raise Exception(
                "Something went wrong while retriveing git revision"
            )

        return out

    def _get_git_current_branch(self):
        out, err, retcode = run_shell_get_output(
            "git rev-parse --abbrev-ref HEAD",
            cwd=self.checkout_path,
        )

        if err or retcode:
            raise Exception(
                "Something went wrong while retriveing git revision"
            )

        return out

    def _update_dockerfile_from_tag(self, dockerfile_path):
        dockerfile_lines = []
        with open(dockerfile_path) as dockerfile:
            dockerfile_lines = dockerfile.readlines()

        # Remove ARG since it is incompatible with version of docker used in
        # sandbox LXC image
        if dockerfile_lines[0].startswith("ARG"):
            dockerfile_lines.pop(0)

        # Update parent image revision
        if self.Parameters.docker_registry_parent_image:
            for line in range(len(dockerfile_lines)):
                if dockerfile_lines[line].startswith("FROM"):
                    dockerfile_lines[line] = "FROM {}\n".format(
                        self.Parameters.docker_registry_parent_image,
                    )

        with open(dockerfile_path, "w") as dockerfile:
            dockerfile.writelines(dockerfile_lines)

    def prepare_resource(self):
        git_clone_retries = 5

        for _ in range(git_clone_retries - 1):
            try:
                self.git_clone(self.Parameters.use_lfs, self.Parameters.update_submodules)
                break
            except:
                logging.exception("Git clone has failed. Retrying.")
        else:
            self.git_clone(self.Parameters.use_lfs, self.Parameters.update_submodules)

        dir_path = os.path.join(self.checkout_path, self.Parameters.path_to_dockerfile)
        dockerfile_path = os.path.join(dir_path, self.Parameters.dockerfile_name)
        if not os.path.exists(dockerfile_path):
            raise common.errors.TaskError("Dockerfile {} not found inside the repository".format(
                dockerfile_path)
            )

        self._update_dockerfile_from_tag(dockerfile_path)

        # FIXME: dirty hack to set commit and branch parameters for task
        # after checking out repository. It will be more appropriate to
        # set these parameters in parent task while calling this task, but in
        # this case you have to checkout git repository there.
        self.Context._vcs_commit = self._get_git_latest_commit()
        self.Context._vcs_branch = self._get_git_current_branch()

        # make sure dockerfile is named 'Dockerfile' so that the child task could fetch it
        shutil.move(dockerfile_path, os.path.join(dir_path, 'Dockerfile'))
        resource = DockerContentResourse(
            self,
            "Dockerfile and contents from {repo}".format(
                repo=self.Parameters.repository,
            ),
            dir_path
        )
        sdk2.ResourceData(resource).ready()
        return resource

    def on_execute(self):
        # Create empty resourse to make this task releasable
        resource = sdk2.ResourceData(
            PaysysDockerDummyResource(
                self, "Output file", "dummy.txt"
            ),
        )
        resource.path.write_bytes("")

        super(PaysysBuildDockerImageFromGit, self).on_execute()

    def on_release(self, params):
        # Mark all children tasks resources as an important to preserve them
        # and tasks they are related to. We are doing it just in case, because
        # It is not guaranteed that the release of the child task will be
        # finished successfully
        resources = sdk2.resource.Resource.find(
            task_id=[self.id] + self.Context.subtasks_ids
        ).limit(0)
        for resource in resources:
            self.server.resource[resource.id].update(
                {
                    "attributes": {
                        "ttl": "inf",
                        "backup_task": True,
                    }
                }
            )
