import logging
import subprocess


def run_shell_get_output(command, **kwargs):
    """Wrapper for running shell scrpts.

    1. Run process.
    2. Wait while it finished.
    3. Log stdout, stderr and exit code.
    4. Return stdout, stderr and exit code.
    Arguments:
    command -- string shell command
    """

    logging.info("Trying to run command: {0}".format(command))
    p = subprocess.Popen(
        command, shell=True,
        stdout=subprocess.PIPE,
        stderr=subprocess.PIPE,
        **kwargs
    )
    out, err = p.communicate()

    logging.info("STDOUT: {}".format(out))
    logging.error("STDERR: {}".format(err))

    retcode = p.returncode

    # Print error if return code is not 0
    if retcode != 0:
        e = "Command '{0}' exited with return code {1}".format(command, retcode)
        logging.error(e)

    return (out, err, retcode)
