from sandbox import sdk2
from sandbox.projects.paysys.tasks.docker.PaysysDockerFromArcadia import PaysysDockerFromArcadia
from sandbox.projects.paysys.lib.docker.main import PARENT_TASK_PARAM_NAME


class PaysysDockerFromArcadiaParametersAdmin(PaysysDockerFromArcadia.Parameters):
    docker_registry_login = sdk2.parameters.String(
        "Registry login", default="robot-ps-test-ci", required=True,
    )
    docker_token_vault_name = sdk2.parameters.String(
        "Registry token vault name",
        default="robot-ps-test-ci-registry",
        required=True,
    )
    docker_token_vault_owner = sdk2.parameters.String(
        "Registry token vault owner", default="PAYSYSADMIN", required=True,
    )
    docker_ssh_vault_name = sdk2.parameters.String(
        "SSH vault name", default="robot-ps-test-ci-ssh", required=True,
    )
    docker_ssh_vault_owner = sdk2.parameters.String(
        "SSH vault owner", default="PAYSYSADMIN", required=True,
    )


class PaysysDockerFromArcadiaParametersOther(PaysysDockerFromArcadia.Parameters):
    docker_registry_login = sdk2.parameters.String(
        "Registry login", default="robot-ps-registry", required=True,
    )
    docker_token_vault_name = sdk2.parameters.String(
        "Registry token vault name",
        default="robot-ps-registry-oauth",
        required=True,
    )
    docker_token_vault_owner = sdk2.parameters.String(
        "Registry token vault owner", default="PAYSYS", required=True,
    )
    docker_ssh_vault_name = sdk2.parameters.String(
        "SSH vault name", default="robot-ps-registry-ssh", required=True,
    )
    docker_ssh_vault_owner = sdk2.parameters.String(
        "SSH vault owner", default="PAYSYS", required=True,
    )


class PaysysDockerBaseXenial(PaysysDockerFromArcadia):
    _docker_os_type = 'xenial'
    _docker_registry_path = "paysys"
    _docker_app_name = "base"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package-base-{}.json".format(
        _docker_os_type
    )
    _parent_task_type = None

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = None

    @property
    def _children_classes(self):
        return [
            PaysysDockerBalanceFopServerXenial,
            PaysysDockerBalanceUserapikeysXenial,
            PaysysDockerRefsXenial,
            PaysysDockerTimelineXenial,
            PaysysDockerTrustFraudAdminXenial,
            PaysysDockerTrustDocsXenial,
            PaysysDockerUzedoBaseXenial,
            PaysysDockerMongoIdmBaseXenial,
            PaysysDockerScroogeBaseXenial,
            PaysysDockerScroogeRedirectXenial,
            PaysysDockerFindepstbotBaseXenial,
            PaysysDockerNirvanaRouterBaseXenial,
            PaysysDockerMongoUnittestXenial,
            PaysysDockerAssessorProxyXenial,
            PaysysDockerBalanceDcsXenial,
        ]


class PaysysDockerBaseBionic(PaysysDockerFromArcadia):
    _docker_os_type = 'bionic'
    _docker_registry_path = "paysys"
    _docker_app_name = "base"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package-base-{}.json".format(
        _docker_os_type
    )
    _parent_task_type = None

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = None

    @property
    def _children_classes(self):
        return [
            PaysysDockerBalanceFopServerBionic,
            PaysysDockerBalanceUserapikeysBionic,
            PaysysDockerRefsBionic,
            PaysysDockerTimelineBionic,
            PaysysDockerTrustFraudAdminBionic,
            PaysysDockerTrustDocsBionic,
            PaysysDockerUzedoBaseBionic,
            PaysysDockerMongoIdmBaseBionic,
            PaysysDockerScroogeBaseBionic,
            PaysysDockerScroogeRedirectBionic,
            PaysysDockerFindepstbotBaseBionic,
            PaysysDockerNirvanaRouterBaseBionic,
            PaysysDockerMongoUnittestBionic,
            PaysysDockerAssessorProxyBionic,
            PaysysDockerBalanceDcsBionic,
            PaysysDockerUzcard3dsBionic,
            PaysysDockerPaysysBotBionic,
        ]


class PaysysDockerBalanceFopServerXenial(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "balance-fop-server"}
    _docker_registry_path = "paysys"
    _docker_app_name = "balance-fop-server"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerBaseXenial

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseXenial.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerBalanceFopServerBionic(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "balance-fop-server"}
    _docker_registry_path = "paysys"
    _docker_app_name = "balance-fop-server"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerBaseBionic

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseBionic.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerBalanceUserapikeysXenial(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "balance-userapikeys"}
    _docker_registry_path = "paysys"
    _docker_app_name = "balance-userapikeys"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerBaseXenial

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseXenial.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerBalanceUserapikeysBionic(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "balance-userapikeys"}
    _docker_registry_path = "paysys"
    _docker_app_name = "balance-userapikeys"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerBaseBionic

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseBionic.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerRefsXenial(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "refs"}
    _docker_registry_path = "paysys"
    _docker_app_name = "refs"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerBaseXenial

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseXenial.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerRefsBionic(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "refs"}
    _docker_registry_path = "paysys"
    _docker_app_name = "refs"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerBaseBionic

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseBionic.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerTimelineXenial(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "timeline"}
    _docker_registry_path = "paysys"
    _docker_app_name = "timeline"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerBaseXenial

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseXenial.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerTimelineBionic(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "timeline"}
    _docker_registry_path = "paysys"
    _docker_app_name = "timeline"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerBaseBionic

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseBionic.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerTrustFraudAdminXenial(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "trust-fraud-admin"}
    _docker_registry_path = "paysys"
    _docker_app_name = "trust-fraud-admin"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerBaseXenial

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseXenial.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerTrustFraudAdminBionic(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "trust-fraud-admin"}
    _docker_registry_path = "paysys"
    _docker_app_name = "trust-fraud-admin"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerBaseBionic

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseBionic.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerTrustDocsXenial(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "trust-docs"}
    _docker_registry_path = "paysys"
    _docker_app_name = "trust-docs"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerBaseXenial

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseXenial.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerTrustDocsBionic(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "trust-docs"}
    _docker_registry_path = "paysys"
    _docker_app_name = "trust-docs"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerBaseBionic

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseBionic.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerUzedoBaseXenial(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "uzedo-base"}
    _docker_registry_path = "paysys"
    _docker_app_name = "uzedo-base"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerBaseXenial

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseXenial.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return [PaysysDockerUzedoXenial]


class PaysysDockerUzedoBaseBionic(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "uzedo-base"}
    _docker_registry_path = "paysys"
    _docker_app_name = "uzedo-base"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerBaseBionic

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseBionic.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return [PaysysDockerUzedoBionic]


class PaysysDockerUzedoXenial(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "uzedo"}
    _docker_registry_path = "paysys"
    _docker_app_name = "uzedo"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerUzedoBaseXenial

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerUzedoBaseXenial.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerUzedoBionic(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "uzedo"}
    _docker_registry_path = "paysys"
    _docker_app_name = "uzedo"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerUzedoBaseBionic

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerUzedoBaseBionic.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerMongoIdmBaseXenial(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "mongo-idm-base"}
    _docker_registry_path = "paysys"
    _docker_app_name = "mongo-idm-base"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerBaseXenial

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseXenial.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return [PaysysDockerMongoIdmXenial]


class PaysysDockerMongoIdmBaseBionic(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "mongo-idm-base"}
    _docker_registry_path = "paysys"
    _docker_app_name = "mongo-idm-base"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerBaseBionic

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseBionic.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return [PaysysDockerMongoIdmBionic]


class PaysysDockerMongoIdmXenial(PaysysDockerFromArcadia):
    _docker_registry_path = "paysys"
    _docker_app_name = "mongo-idm"
    _docker_package_file = "paysys/sre/apps/mongo_idm/package.json"
    _parent_task_type = PaysysDockerMongoIdmBaseXenial

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerMongoIdmBaseXenial.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerMongoIdmBionic(PaysysDockerFromArcadia):
    _docker_registry_path = "paysys"
    _docker_app_name = "mongo-idm"
    _docker_package_file = "paysys/sre/apps/mongo_idm/package.json"
    _parent_task_type = PaysysDockerMongoIdmBaseBionic

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerMongoIdmBaseBionic.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerMongoUnittestXenial(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "mongo-unittest"}
    _docker_registry_path = "paysys"
    _docker_app_name = "mongo-unittest"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerBaseXenial

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseXenial.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerMongoUnittestBionic(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "mongo-unittest"}
    _docker_registry_path = "paysys"
    _docker_app_name = "mongo-unittest"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerBaseBionic

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseBionic.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerScroogeBaseXenial(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "scrooge-base"}
    _docker_registry_path = "paysys"
    _docker_app_name = "scrooge-base"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerBaseXenial

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseXenial.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return [PaysysDockerScroogeXenial]


class PaysysDockerScroogeBaseBionic(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "scrooge-base"}
    _docker_registry_path = "paysys"
    _docker_app_name = "scrooge-base"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerBaseBionic

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseBionic.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return [PaysysDockerScroogeBionic]


class PaysysDockerScroogeXenial(PaysysDockerFromArcadia):
    _docker_registry_path = "paysys"
    _docker_app_name = "scrooge"
    _docker_package_file = "payplatform/scrooge/package.json"
    _parent_task_type = PaysysDockerScroogeBaseXenial

    class Parameters(PaysysDockerFromArcadiaParametersOther):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerScroogeBaseXenial.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerScroogeBionic(PaysysDockerFromArcadia):
    _docker_registry_path = "paysys"
    _docker_app_name = "scrooge"
    _docker_package_file = "payplatform/scrooge/package.json"
    _parent_task_type = PaysysDockerScroogeBaseBionic

    class Parameters(PaysysDockerFromArcadiaParametersOther):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerScroogeBaseBionic.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerScroogeRedirectXenial(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "scrooge-redirect"}
    _docker_registry_path = "paysys"
    _docker_app_name = "scrooge-redirect"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerBaseXenial

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseXenial.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerScroogeRedirectBionic(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "scrooge-redirect"}
    _docker_registry_path = "paysys"
    _docker_app_name = "scrooge-redirect"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerBaseBionic

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseBionic.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerFindepstbotBaseXenial(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "findepstbot-base"}
    _docker_registry_path = "paysys"
    _docker_app_name = "findepstbot-base"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerBaseXenial

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseXenial.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return [PaysysDockerFindepstbotXenial]


class PaysysDockerFindepstbotBaseBionic(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "findepstbot-base"}
    _docker_registry_path = "paysys"
    _docker_app_name = "findepstbot-base"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerBaseBionic

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseBionic.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return [PaysysDockerFindepstbotBionic]


class PaysysDockerFindepstbotXenial(PaysysDockerFromArcadia):
    _docker_registry_path = "paysys"
    _docker_app_name = "findepstbot-app"
    _docker_package_file = "payplatform/findep/findepstbot/package.json"
    _parent_task_type = PaysysDockerFindepstbotBaseXenial

    class Parameters(PaysysDockerFromArcadiaParametersOther):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerFindepstbotBaseXenial.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerFindepstbotBionic(PaysysDockerFromArcadia):
    _docker_registry_path = "paysys"
    _docker_app_name = "findepstbot-app"
    _docker_package_file = "payplatform/findep/findepstbot/package.json"
    _parent_task_type = PaysysDockerFindepstbotBaseBionic

    class Parameters(PaysysDockerFromArcadiaParametersOther):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerFindepstbotBaseBionic.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerNirvanaRouterBaseXenial(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "nirvana-router-base"}
    _docker_registry_path = "paysys"
    _docker_app_name = "nirvana-router-base"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerBaseXenial

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseXenial.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return [PaysysDockerNirvanaRouterXenial]


class PaysysDockerNirvanaRouterBaseBionic(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "nirvana-router-base"}
    _docker_registry_path = "paysys"
    _docker_app_name = "nirvana-router-base"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerBaseBionic

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseBionic.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return [PaysysDockerNirvanaRouterBionic]


class PaysysDockerNirvanaRouterXenial(PaysysDockerFromArcadia):
    _docker_registry_path = "billing"
    _docker_app_name = "nirvana_router"
    _docker_package_file = "billing/nirvana_router/package.json"
    _parent_task_type = PaysysDockerNirvanaRouterBaseXenial

    class Parameters(PaysysDockerFromArcadiaParametersOther):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerNirvanaRouterBaseXenial.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerNirvanaRouterBionic(PaysysDockerFromArcadia):
    _docker_registry_path = "billing"
    _docker_app_name = "nirvana_router"
    _docker_package_file = "billing/nirvana_router/package.json"
    _parent_task_type = PaysysDockerNirvanaRouterBaseBionic

    class Parameters(PaysysDockerFromArcadiaParametersOther):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerNirvanaRouterBaseBionic.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerAssessorProxyXenial(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "assessor-proxy"}
    _docker_registry_path = "paysys"
    _docker_app_name = "assessor-proxy"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerBaseXenial

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseXenial.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerAssessorProxyBionic(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "assessor-proxy"}
    _docker_registry_path = "paysys"
    _docker_app_name = "assessor-proxy"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerBaseBionic

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseBionic.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerBalanceDcsXenial(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "balance-dcs"}
    _docker_registry_path = "paysys"
    _docker_app_name = "balance-dcs"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerBaseXenial

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseXenial.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerBalanceDcsBionic(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "balance-dcs"}
    _docker_registry_path = "paysys"
    _docker_app_name = "balance-dcs"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerBaseBionic

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseBionic.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerPaysysBotBionic(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "paysysbot"}
    _docker_registry_path = "paysys"
    _docker_app_name = "paysysbot"
    _docker_package_file = "paysys/sre/apps/paysysbot/package.json"
    _parent_task_type = PaysysDockerBaseBionic

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseBionic.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerUzcard3dsBionic(PaysysDockerFromArcadia):
    _docker_build_args = {"APP_NAME": "uzcard3ds"}
    _docker_registry_path = "paysys"
    _docker_app_name = "uzcard3ds"
    _docker_package_file = "paysys/sre/tools/ansible-docker/package.json"
    _parent_task_type = PaysysDockerBaseBionic

    class Parameters(PaysysDockerFromArcadiaParametersAdmin):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerBaseBionic.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []

