from sandbox.projects.paysys.tasks.docker.PaysysBuildDockerImageFromGit import PaysysBuildDockerImageFromGit
from sandbox.projects.paysys.lib.docker.main import PaysysDocker


class PaysysDockerFromGit(PaysysDocker):
    def _create_build_task(self):
        build_task_kwargs = {
            "repository": self._dockerfile_repository,
            "dockerfile_name": self._dockerfile_name,
            "ssh_vault_name": self.Parameters.docker_ssh_vault_name,
            "ssh_vault_owner": self.Parameters.docker_ssh_vault_owner,
            "registry_tags": [self.Context.built_image],
            "registry_login": self.Parameters.docker_registry_login,
            "oauth_vault_name": self.Parameters.docker_token_vault_name,
            "oauth_vault_owner": self.Parameters.docker_token_vault_owner,
            "docker_registry_parent_image": None if self._parent_task_type is None else self._parent_task.Context.built_image,
            "commit": self.Parameters.vcs_commit,
            "branch": self.Parameters.vcs_branch,
            "docker_build_args": self._docker_build_args,
        }
        build_task = PaysysBuildDockerImageFromGit(
            self,
            description="Child of {}".format(self.id),
            owner=self.owner,
            **build_task_kwargs
        )

        return build_task

    def _update_context_from_build_task(self, build_task):
        # This is needed only for git, because for arcadia task we can get
        # the latest commit from the outside (it is true for git too
        # actually, but code haven't been written yet)

        self.Context._vcs_commit = build_task.Context._vcs_commit
        self.Context._vcs_branch = build_task.Context._vcs_branch
        self.Context.save()
