from sandbox import sdk2
from sandbox.projects.paysys.lib.docker.main import (
    PaysysDocker, PaysysDockerDummyResource, PARENT_TASK_PARAM_NAME,
)


class PaysysDockerTestDoNothing(sdk2.Task):
    class Requirements(sdk2.Requirements):
        disk_space = 512
        cores = 1

    def on_execute(self):
        self.Context._vcs_commit = "testcommit1337"
        self.Context._vcs_branch = "testbranch"
        self.Context.built_image = "registry.yandex.net/st/root:123"
        self.Context.save()

        # Create empty resourse to make this task releasable
        resource = sdk2.ResourceData(
            PaysysDockerDummyResource(
                self, "Output file", "dummy.txt"
            ),
        )
        resource.path.write_bytes("")


class PaysysDockerTest(PaysysDocker):
    def _save_manifest_from_registry(self):
        pass

    def _set_registry_tag(self, new_registry_tag):
        pass

    def _create_build_task(self):
        task = PaysysDockerTestDoNothing(
            self,
            description="Child of {}".format(self.id),
            owner=self.owner,
        )

        return task


class PaysysDockerTestRoot(PaysysDockerTest):
    _dockerfile_repository = "root_repo"
    _dockerfile_name = "Dockerfile"
    _docker_build_args = []
    _docker_registry_path = "paysys-test"
    _docker_app_name = "root"
    _parent_task_type = None

    class Parameters(PaysysDockerTest.Parameters):
        parent_task = None

    @property
    def _children_classes(self):
        return [
            PaysysDockerTestLevel1Task1,
            PaysysDockerTestLevel1Task2,
        ]


class PaysysDockerTestLevel1Task1(PaysysDockerTest):
    _dockerfile_repository = "level1_task1"
    _dockerfile_name = "Dockerfile"
    _docker_build_args = ["APP_NAME=level1_task1"]
    _docker_registry_path = "paysys-test"
    _docker_app_name = "level1_task1"
    _parent_task_type = PaysysDockerTestRoot

    class Parameters(PaysysDockerTest.Parameters):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerTestRoot.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []


class PaysysDockerTestLevel1Task2(PaysysDockerTest):
    _dockerfile_repository = "level1_task2"
    _dockerfile_name = "Dockerfile"
    _docker_build_args = ["APP_NAME=level1_task2"]
    _docker_registry_path = "paysys-test"
    _docker_app_name = "level1_task2"
    _parent_task_type = PaysysDockerTestRoot

    class Parameters(PaysysDockerTest.Parameters):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerTestRoot.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return [PaysysDockerTestLevel2Task2]


class PaysysDockerTestLevel2Task2(PaysysDockerTest):
    _dockerfile_repository = "level2_task2"
    _dockerfile_name = "Dockerfile"
    _docker_build_args = ["APP_NAME=level2_task2"]
    _docker_registry_path = "paysys-test"
    _docker_app_name = "level2_task2"
    _parent_task_type = PaysysDockerTestLevel1Task2

    class Parameters(PaysysDockerTest.Parameters):
        parent_task = sdk2.parameters.Task(
            PARENT_TASK_PARAM_NAME,
            task_type=PaysysDockerTestLevel1Task2.type,
            default=None,
        )

    @property
    def _children_classes(self):
        return []
