def log_to_colored_html(log_lines):
    result_html = ""
    color = "black"
    for line in log_lines:
        colors = {
            "INFO": "green",
            "DEBUG": "gray",
            "WARNING": "orange",
            "ERROR": "red",
        }
        line_sp = line.split(None, 3)

        line_html = None

        if len(line_sp) > 2 and line_sp[2] in colors:
            date = line_sp[0]
            timestamp = line_sp[1]
            log_level = line_sp[2]
            message = line_sp[3].rstrip("\n")

            color = colors[log_level]

            line_html = '{} {} <font color="{}"><b>{}</b> {}</font>\n'.format(
                date,
                timestamp,
                color,
                log_level,
                message,
            )
        else:
            line_html = '<font color="{}">{}</font>\n'.format(
                color,
                line.rstrip("\n"),
            )

        result_html += line_html

    return "<html><body><pre>" + result_html + "</pre></body></html>"
