from parameters import ApphostSUTParameters

from sandbox.projects.yabs.qa.adapter_base.sandbox import SandboxAdapterBase

from sandbox.projects.pcode.qa.apphost.sut import ApphostSUT
from sandbox.projects.pcode.qa.apphost.sut.adapters.interface import ApphostSUTAdapterInterface


class ApphostSUTSandboxAdapter(ApphostSUTAdapterInterface, SandboxAdapterBase):
    def __init__(self, parameters, task_instance):
        SandboxAdapterBase.__init__(self, parameters, task_instance)

    @staticmethod
    def get_init_parameters_class():
        return ApphostSUTParameters

    def get_apphost_port(self):
        return self.parameters.apphost_port

    def get_apphost_vertical(self):
        return self.parameters.vertical

    def get_apphost_mode(self):
        return self.parameters.apphost_mode

    def get_arcadia_revision(self):
        return self.parameters.arcadia_revision

    def get_tokens(self):
        return {
            "SANDBOX_AUTH_TOKEN": self.parameters.sandbox_token.data()[self.parameters.sandbox_token.default_key],
            "YA_TOKEN": self.parameters.ya_token.data()[self.parameters.ya_token.default_key],
            "YT_TOKEN": self.parameters.yt_token.data()[self.parameters.yt_token.default_key],
        }

    def create_module(self):
        return ApphostSUT(self)
