from sandbox import sdk2


DEFAULT_PORT = 10090


class ApphostSUTParameters(sdk2.Task.Parameters):
    apphost_port = sdk2.parameters.Integer('Port for apphost', default_value=DEFAULT_PORT)
    apphost_mode = sdk2.parameters.String(
        "Apphost mode (agent or arcadia)",
        default='agent',
    )
    arcadia_revision = sdk2.parameters.String(
        "Arcadia revision for apphost (trunk or svn revision)",
        default='trunk',
    )
    vertical = sdk2.parameters.String(
        "Apphost vertical",
        required=True,
    )

    ya_token = sdk2.parameters.YavSecretWithKey(
        'YA token',
        required=True,
    )

    yt_token = sdk2.parameters.YavSecretWithKey(
        'YT token',
        required=True,
    )

    sandbox_token = sdk2.parameters.YavSecretWithKey(
        'SANDBOX token',
        required=True,
    )
