from sandbox.common.fs import get_unique_file_name

from sandbox.projects.yabs.qa.module_base import ModuleBase
from sandbox.projects.common.yabs.cachedaemon import CacheDaemonStubSandboxNonIntegrated


class CacheDaemonRunSUT(ModuleBase):

    def __init__(self, adapter):
        ModuleBase.__init__(self, adapter)
        self._active = False
        services_ports = self.adapter.get_cache_daemon_ports_map()
        self._cachedaemon = CacheDaemonStubSandboxNonIntegrated(
            cache_daemon_executable_path=self.adapter.get_cache_daemon_executable_path(),
            dump_path=self.adapter.get_cache_daemon_stub_path(),
            data_dir=get_unique_file_name(self.adapter.get_work_dir(), 'cache_daemon_data'),
            log_subdir=get_unique_file_name(self.adapter.get_logs_dir(), 'cache_daemon_logs'),
            start_on_creation=False,
            key_header=self.adapter.get_cache_daemon_key_headers(),
            services=None,
            services_ports=services_ports,
        )

    def __enter__(self):
        self._cachedaemon.__enter__()
        self._active = True
        return self

    def __exit__(self, *args):
        self._cachedaemon.__exit__(*args)
        self._active = False
