import os

from sandbox import sdk2
from sandbox.projects.yabs.qa.adapter_base.sandbox import SandboxAdapterBase
from sandbox.projects.resource_types import CACHE_DAEMON
from sandbox.sandboxsdk.paths import get_logs_folder

from sandbox.projects.pcode.qa.mobile_ads_sdk.cache_daemon_sut.adapters.sandbox.parameters import CacheDaemonSUTParameters
from sandbox.projects.pcode.qa.mobile_ads_sdk.cache_daemon_sut import CacheDaemonRunSUT


class CacheDaemonRunSUTSandboxAdapter(SandboxAdapterBase):
    def __init__(self, parameters, task_instance):
        SandboxAdapterBase.__init__(self, parameters, task_instance)

    @staticmethod
    def get_init_parameters_class():
        return CacheDaemonSUTParameters

    def get_work_dir(self):
        return os.getcwd()

    def get_logs_dir(self):
        return get_logs_folder()

    def get_cache_daemon_stub_path(self):
        return self.sync_resource(self.parameters.cache_daemon_stub_resource)

    def get_cache_daemon_executable_path(self):
        cache_daemon_executable_res_id = self.parameters.cache_daemon_stub_resource.cache_daemon_res_id
        return self.sync_resource(sdk2.Resource.find(CACHE_DAEMON, id=cache_daemon_executable_res_id).first())

    def get_cache_daemon_key_headers(self):
        return self.parameters.cache_daemon_stub_resource.key_header

    def get_cache_daemon_ports_map(self):
        return self.parameters.cache_daemon_ports_map

    def create_module(self):
        return CacheDaemonRunSUT(self)
