from sandbox.projects.pcode.qa.apphost.sut.adapters.sandbox import ApphostSUTSandboxAdapter
from sandbox.projects.pcode.qa.mobile_ads_sdk.sut.adapters.sandbox import MobileAdsSdkSUTSandboxAdapter
from sandbox.projects.pcode.qa.mobile_ads_sdk.cache_daemon_sut.adapters.sandbox import CacheDaemonRunSUTSandboxAdapter
from sandbox.projects.pcode.qa.mobile_ads_sdk.janpu_graph_sut.adapters.sandbox.parameters import JanpuGraphSUTParameters
from sandbox.projects.pcode.qa.multiple_sut_wrapper.sut.adapters.sandbox import MultipleSUTSandboxAdapter


class JanpuGraphSUTSandboxAdapter(MultipleSUTSandboxAdapter):
    sut_name_to_adapter_class = {
        "apphost": ApphostSUTSandboxAdapter,
        "mobile_ads_sdk": MobileAdsSdkSUTSandboxAdapter,
        "cache_daemon_run": CacheDaemonRunSUTSandboxAdapter,
    }

    def __init__(self, parameters, task_instance):
        MultipleSUTSandboxAdapter.__init__(self, parameters, task_instance)

    @staticmethod
    def get_init_parameters_class():
        return JanpuGraphSUTParameters
