from sandbox import sdk2

from sandbox.projects.pcode.qa.apphost.sut.adapters.sandbox.parameters import ApphostSUTParameters
from sandbox.projects.pcode.qa.mobile_ads_sdk.sut.adapters.sandbox.parameters import MobileAdsSdkSUTParameters
from sandbox.projects.pcode.qa.mobile_ads_sdk.cache_daemon_sut.adapters.sandbox.parameters import CacheDaemonSUTParameters


class JanpuGraphSUTParameters(sdk2.Task.Parameters):
    with sdk2.parameters.Group('Apphost SUT parameters:') as apphost_sut_group:
        apphost = ApphostSUTParameters()

    with sdk2.parameters.Group('Mobile Ads Sdk SUT parameters:') as mobile_ads_sdk_sut_group:
        mobile_ads_sdk = MobileAdsSdkSUTParameters()

    with sdk2.parameters.Group('Cache Daemon SUT parameters:') as cache_daemon_sut_group:
        cache_daemon = CacheDaemonSUTParameters()

    port = sdk2.parameters.Integer('Port', required=True)

    with sdk2.parameters.Output:
        output_yt_path = sdk2.parameters.String('Output yt table path')
