import os

from parameters import MobileAdsSdkSUTParameters, MobileAdsSdkSUTParametersSecondRun
from sandbox.projects.yabs.qa.adapter_base.sandbox import SandboxAdapterBase
from sandbox.projects.pcode.qa.mobile_ads_sdk.sut import MobileAdsSdkSUT
from sandbox.projects.pcode.qa.mobile_ads_sdk.sut.adapters.interface import MobileAdsSdkSUTAdapterInterface


class MobileAdsSdkSUTSandboxAdapter(MobileAdsSdkSUTAdapterInterface, SandboxAdapterBase):
    def __init__(self, parameters, task_instance, work_dir=None):
        SandboxAdapterBase.__init__(self, parameters, task_instance)
        self._work_dir = work_dir or os.getcwd()

    @staticmethod
    def get_init_parameters_class(second_run=False):
        return MobileAdsSdkSUTParameters if not second_run else MobileAdsSdkSUTParametersSecondRun

    def get_jdk_resource_path(self):
        return self.sync_resource(self.parameters.jdk_resource)

    def get_mobile_ads_sdk_resource_path(self):
        return self.sync_resource(self.parameters.mobile_ads_sdk_resource)

    def get_work_dir(self):
        return self._work_dir

    def get_core_count(self):
        return self.parameters.core_count

    def get_mobile_ads_sdk_port(self):
        return self.parameters.mobile_ads_sdk_port

    def create_module(self):
        return MobileAdsSdkSUT(self)
