from sandbox import sdk2
from sandbox.projects.pcode.resources import MobileAdsSdkServiceResource
from sandbox.projects.resource_types import JAVA_JDK_ENVIRONMENT


class MobileAdsSdkSUTParameters(sdk2.Task.Parameters):
    with sdk2.parameters.Group("Janpu sut parameters:") as sut_group:
        core_count = sdk2.parameters.Integer('Core count', default_value=1)
        mobile_ads_sdk_port = sdk2.parameters.Integer('Port for mobile ads sdk', required=True)
        mobile_ads_sdk_resource = sdk2.parameters.Resource('Resource with mobile ads sdk package', resource_type=MobileAdsSdkServiceResource, required=True)
        jdk_resource = sdk2.parameters.Resource('Resource with java jdk environment', resource_type=JAVA_JDK_ENVIRONMENT, required=True)


class MobileAdsSdkSUTParametersSecondRun(sdk2.Task.Parameters):
    with sdk2.parameters.Group("Janpu sut parameters for second run:") as sut_group_second_run:
        core_count_2 = sdk2.parameters.Integer('Core count', default_value=1)
        mobile_ads_sdk_port_2 = sdk2.parameters.Integer('Port for mobile ads sdk', required=True)
        mobile_ads_sdk_resource_2 = sdk2.parameters.Resource('Resource with mobile ads sdk package', resource_type=MobileAdsSdkServiceResource, required=True)
        jdk_resource_2 = sdk2.parameters.Resource('Resource with java jdk environment', resource_type=JAVA_JDK_ENVIRONMENT, required=True)
