from sandbox import sdk2

from sandbox.projects.pcode.qa.apphost.sut.adapters.sandbox.parameters import ApphostSUTParameters
from sandbox.projects.pcode.qa.report_renderer.sut.adapters.sandbox.parameters import SsrSUTParameters


DEFAULT_PORTS_MAP = {
    'renderer_admin_port': 3221,
    'renderer_port': 3222,
    'cache_daemon_ports': {
        'AD_ENGINE': 10050,
    }
}


class PCodeGraphSUTParameters(sdk2.Task.Parameters):
    with sdk2.parameters.Group('Apphost SUT parameters:') as apphost_sut_group:
        apphost = ApphostSUTParameters()

    with sdk2.parameters.Group('Ssr SUT parameters:') as ssr_sut_group:
        ssr = SsrSUTParameters()

    port = sdk2.parameters.Integer('Port', required=True)
