import os
import json
import requests
from parameters import SsrSUTParameters

from sandbox.projects.yabs.qa.adapter_base.sandbox import SandboxAdapterBase
from sandbox.sandboxsdk.paths import get_logs_folder

from sandbox.projects.pcode.qa.report_renderer.sut.adapters.interface import SsrSUTAdapterInterface
from sandbox.projects.pcode.qa.report_renderer.sut import SsrSUT


class SsrSUTSandboxAdapter(SsrSUTAdapterInterface, SandboxAdapterBase):

    def __init__(self, parameters, task_instance):
        SandboxAdapterBase.__init__(self, parameters, task_instance)

    @staticmethod
    def get_init_parameters_class():
        return SsrSUTParameters

    @staticmethod
    def get_logs_dir():
        return get_logs_folder()

    @staticmethod
    def get_work_dir():
        return os.getcwd()

    @staticmethod
    def _get_resource_id(_resource):
        return _resource.id if _resource else 0

    def get_pcode_resource_path(self):
        return self.sync_resource(self.parameters.pcode_package_resource)

    def get_node_relpath(self):
        return self.parameters.pcode_package_resource.node_relpath

    def get_cache_daemon_stub_path(self):
        return self.sync_resource(self.parameters.cache_daemon_stub_resource)

    def get_cache_daemon_executable_path(self):
        cache_daemon_executable_res_id = self.parameters.cache_daemon_stub_resource.cache_daemon_res_id
        return self.sync_resource(cache_daemon_executable_res_id)

    def get_cache_daemon_key_headers(self):
        return self.parameters.cache_daemon_stub_resource.key_header

    def get_ports_map(self):
        return self.parameters.ports_map

    def get_tokens(self):
        return {
            "SANDBOX_AUTH_TOKEN": self.parameters.sandbox_token.data()[self.parameters.sandbox_token.default_key],
            "YA_TOKEN": self.parameters.ya_token.data()[self.parameters.ya_token.default_key],
            "YT_TOKEN": self.parameters.yt_token.data()[self.parameters.yt_token.default_key],
        }

    def get_web_pcode_micro_package_id(self):
        return self._get_resource_id(self.parameters.web_pcode_micro_package_resource)

    def get_pcode_loader_superbundle_id(self):
        return self._get_resource_id(self.parameters.pcode_loader_superbundle_resource)

    def get_pcode_vas_superbundle_id(self):
        return self._get_resource_id(self.parameters.pcode_vas_superbundle_resource)

    def get_pcodever(self):
        if self.parameters.pcodever:
            return self.parameters.pcodever
        r = requests.get('https://ab.yandex-team.ru/api/testid/400882',
                         headers={'Authorization': 'OAuth {}'.format(self.parameters.adsdkver.data()['ab_token'])})
        r.raise_for_status()
        params = json.loads(r.json()["params"])
        return int(params[0]["CONTEXT"]["FLAGS"]["PCODEVER"])

    def get_adsdkver(self):
        return self.parameters.adsdkver

    def create_module(self):
        return SsrSUT(self)
