from sandbox import sdk2
from sandbox.projects.sandbox_ci.resources.generated import WebPcodeMicroPackage

from sandbox.projects.pcode.qa.resource_types import PCODE_RR_CACHE_DAEMON_STUB_DATA, PcodeRendererResource
from sandbox.projects.pcode.resources import PcodeLoaderSuperbundle, PcodeVasSuperbundle


DEFAULT_PORTS_MAP = {
    'renderer_admin_port': 3221,
    'renderer_port': 3222,
    'cache_daemon_ports': {
        'AD_ENGINE': 10050,
    }
}


class SsrSUTParameters(sdk2.Task.Parameters):
    cache_daemon_stub_resource = sdk2.parameters.Resource(
        'Cache daemon stub',
        resource_type=PCODE_RR_CACHE_DAEMON_STUB_DATA,
    )
    pcode_package_resource = sdk2.parameters.Resource(
        'Resource with PCODE content',
        resource_type=PcodeRendererResource,
    )
    web_pcode_micro_package_resource = sdk2.parameters.LastReleasedResource(
        'WEB_PCODE_MICRO_PACKAGE resource to run in renderer',
        resource_type=WebPcodeMicroPackage,
    )
    pcode_loader_superbundle_resource = sdk2.parameters.LastReleasedResource(
        'PCODE_LOADER_SUPERBUNDLE resource to build in renderer',
        resource_type=PcodeLoaderSuperbundle,
    )
    pcodever = sdk2.parameters.Integer(
        'PCODEVER in query args',
        description='Used PCODEVER from https://ab.yandex-team.ru/testid/400882 as default',
        required=True, default=0,
    )
    ab_oauth_token = sdk2.parameters.YavSecret(
        'AB OAuth token',
        required=True,
        default="sec-01ftb7ezzkgz3wajmq5htkaxnf"
    )
    pcode_vas_superbundle_resource = sdk2.parameters.LastReleasedResource(
        'PCODE_VAS_SUPERBUNDLE resource to build in renderer',
        resource_type=PcodeVasSuperbundle,
    )
    adsdkver = sdk2.parameters.Integer(
        'ADSDKVER in query args',
        description='Used VAS_STABLE_VERSION as default',
        required=True, default=0,
    )
    ports_map = sdk2.parameters.JSON('Ports services will be run on', default_value=DEFAULT_PORTS_MAP)
