# -*- coding: utf8 -*-

ARCHON_RENDERER_PATCH = """--- renderer2.js	2022-01-26 17:20:37.000000000 +0300
+++ renderer.js	2022-01-26 20:54:01.000000000 +0300
@@ -127,6 +127,8 @@
                 args.push('--coverage-profile-dir', coverageProfileDir);
             }

+            args.push('--service-properties', `{"bundlePath":"/resources-local-prepared/pcode.json", "vasBundlePath":"/resources-local-prepared/vas.json"}`);
+
             const env = {
                 LUSTER_CONF: LUSTER_CONF.join(';'),
                 NODE_PATH: this.nodeModulesPath,
"""

LOAD_PCODE_RESOURCE_PATCH = """--- load-pcode-resource.js	2022-01-24 19:07:55.000000000 +0300
+++ load-pcode-resource-patch.js	2022-01-27 13:49:49.000000000 +0300
@@ -32,9 +32,84 @@
     }
 }

+class PcodeLoaderSuperbundle {
+    constructor(resourceId = 0) {
+        console.log(resourceId);
+        this.filter = resourceId ? { id: resourceId } : { attrs: { released: 'stable' } };
+        this.name = 'pcode-loader-superbundle';
+        this._resource = new SandboxResource({
+            cacheFsName: 'pcode-loader-superbundle',
+            name: 'PCODE_LOADER_SUPERBUNDLE',
+            strategy: 'file',
+            filter: this.filter,
+        });
+    }
+
+    async init() {
+        const resourcePath = await this._resource.install();
+        const dir = path.resolve(__dirname, '../../../resources-local-prepared');
+        if (!fs.existsSync(dir)) {
+            fs.mkdirSync(dir);
+        }
+        const loaderPath = path.resolve(path.dirname(resourcePath), 'pcode-loader-superbundle');
+        const newLoaderPath = path.resolve(dir, 'pcode.json');
+
+        console.log('---------------------------------------------');
+        console.log('Resource "PCODE_LOADER_SUPERBUNDLE" has been loaded');
+        console.log('---------------------------------------------');
+
+        fs.copyFileSync(loaderPath, newLoaderPath);
+
+        return this._resource;
+    }
+
+    get resource() {
+        return this._resource;
+    }
+}
+
+class PcodeVasSuperbundle {
+    constructor(resourceId = 0) {
+        this.filter = resourceId ? { id: resourceId } : { attrs: { released: 'stable' } };
+        this.name = 'pcode-vas-superbundle';
+        this._resource = new SandboxResource({
+            cacheFsName: 'pcode-vas-superbundle',
+            name: 'PCODE_VAS_SUPERBUNDLE',
+            strategy: 'file',
+            filter: this.filter,
+        });
+    }
+
+    async init() {
+        const resourcePath = await this._resource.install();
+        const dir = path.resolve(__dirname, '../../../resources-local-prepared');
+        if (!fs.existsSync(dir)) {
+            fs.mkdirSync(dir);
+        }
+        const vasPath = path.resolve(path.dirname(resourcePath), 'pcode-vas-superbundle');
+        const newVasPath = path.resolve(dir, 'vas.json');
+
+        console.log('---------------------------------------------');
+        console.log('Resource "PCODE_VAS_SUPERBUNDLE" has been loaded');
+        console.log('---------------------------------------------');
+
+        fs.copyFileSync(vasPath, newVasPath);
+
+        return this._resource;
+    }
+
+    get resource() {
+        return this._resource;
+    }
+}
+
 module.exports.PcodeResourceLoader = PcodeResourceLoader;
+module.exports.PcodeLoaderSuperbundle = PcodeLoaderSuperbundle;
+module.exports.PcodeVasSuperbundle = PcodeVasSuperbundle;

 // Для CI
 if (require.main === module) {
     new PcodeResourceLoader().init();
+    new PcodeLoaderSuperbundle().init();
+    new PcodeVasSuperbundle().init();
 }
"""

PCODE_RENDERER_PATCH = """--- pcode-renderer.js	2022-01-24 19:07:55.000000000 +0300
+++ pcode-renderer-patch.js	2022-01-27 13:49:56.000000000 +0300
@@ -1,5 +1,5 @@
 const archonRenderer = require('@yandex-int/archon-renderer/commands/renderer');
-const { PcodeResourceLoader } = require('../components/load-pcode-resource');
+const { PcodeResourceLoader, PcodeLoaderSuperbundle, PcodeVasSuperbundle } = require('../components/load-pcode-resource');
 const { generateBrokerRunDir, generateBrokerLogDir } = require('@yandex-int/ipbus');
 const { inheritOptions, addEdges } = require('@yandex-int/archon').utils;

@@ -11,6 +11,21 @@
     default: 0,
     group: 'pcode options',
 };
+pcodeRendererOptions['pcode-loader-resource-id'] = {
+    type: 'number',
+    description: 'ID ресурса PCODE_LOADER_SUPERBUNDLE',
+    requiresArg: true,
+    default: 0,
+    group: 'pcode options',
+};
+pcodeRendererOptions['pcode-vas-resource-id'] = {
+    type: 'number',
+    description: 'ID ресурсы PCODE_VAS_SUPERBUNDLE',
+    requiresArg: true,
+    default: 0,
+    group: 'pcode options',
+};
+

 module.exports = {
     name: 'pcode-renderer',
@@ -21,13 +36,25 @@

         const rendererGraph = archonRenderer.graph(options);
         const pcodeResource = new PcodeResourceLoader(options['pcode-resource-id']);
+        const pcodeLoaderSuperbundle = new PcodeLoaderSuperbundle(options['pcode-loader-resource-id']);
+        const pcodeVasSuperbundle = new PcodeVasSuperbundle(options['pcode-vas-resource-id']);

         rendererGraph.push(pcodeResource);
+        rendererGraph.push(pcodeLoaderSuperbundle);
+        rendererGraph.push(pcodeVasSuperbundle);

         addEdges(rendererGraph, {
             component: 'renderer',
             dependsOn: pcodeResource.name,
         });
+        addEdges(rendererGraph, {
+            component: 'renderer',
+            dependsOn: pcodeLoaderSuperbundle.name,
+        });
+        addEdges(rendererGraph, {
+            component: 'renderer',
+            dependsOn: pcodeVasSuperbundle.name,
+        });

         return rendererGraph;
     },
"""
