import difflib

from base_content_parser import JanpuContentParser
from response_parser import ResponseParser


class ResponseDiffer(object):

    def __init__(
        self,
        request_id,
    ):
        self.request_id = request_id

    @staticmethod
    def _string_lists_diff(list_pre, list_test):
        return '\n'.join(difflib.unified_diff(list_pre, list_test, fromfile='pre', tofile='test', lineterm=''))

    def diff_response_data(self, response_prod, response_test):
        parsed_prod = ResponseParser(response_prod, JanpuContentParser)
        parsed_test = ResponseParser(response_test, JanpuContentParser)
        status_diff = self._string_lists_diff(parsed_prod.get_serialized_status(),
                                              parsed_test.get_serialized_status())
        headers_diff = self._string_lists_diff(parsed_prod.get_serialized_headers(),
                                               parsed_test.get_serialized_headers())
        content_diff = self._string_lists_diff(parsed_prod.get_serialized_content(),
                                               parsed_test.get_serialized_content())
        content_type_diff = self._string_lists_diff([parsed_prod.content.content_type],
                                                    [parsed_test.content.content_type])

        return {
            "RequestID": self.request_id,
            "HasDiff": bool(status_diff or headers_diff or content_diff or content_type_diff),
            "StatusDiff": status_diff,
            "HeadersDiff": headers_diff,
            "ContentDiff": content_diff,
            "ContentTypeDiff": content_type_diff,
            "ContentType": "UNKNOWN" if content_type_diff else parsed_prod.content.content_type
        }
