import difflib


class CompareDataReducer(object):

    def __init__(self):
        pass

    @staticmethod
    def _string_lists_diff(list_pre, list_test):
        return '\n'.join(difflib.unified_diff(list_pre, list_test, fromfile='pre', tofile='test', lineterm=''))

    def __call__(self, item):
        request_id = item[0]
        preshoot_row = item[1]
        patched_shoot_row = item[2]

        assert preshoot_row is not None
        assert patched_shoot_row is not None

        pass_diff = ["RequestID", "HasDiff"]
        has_diff = False
        result = {}
        for column_name in preshoot_row.keys():
            if column_name in pass_diff:
                continue
            new_name = column_name + "Diff"
            result[new_name] = self._string_lists_diff(preshoot_row[column_name], patched_shoot_row[column_name])
            has_diff |= bool(result[new_name])
        result["RequestID"] = preshoot_row["RequestID"]
        result["HasDiff"] = has_diff
        result["ContentType"] = "ERROR" if result["ContentTypeDiff"] else preshoot_row["ContentType"][0]
        return request_id, result
