import sys
import json
import logging

from StringIO import StringIO
from httplib import HTTPResponse

logger = logging.getLogger(__name__)


class ContentParser(object):
    def __init__(self, content, modules):
        self.content = content
        self.content_type = "UNKNOWN"

        for module in modules:
            self.content, self.content_type = module.process(self.content, self.content_type)

    def serialized_content(self):
        return self.content.splitlines()


class ResponseParser(object):

    class FakeSocket:
        def __init__(self, response_str):
            self._file = StringIO(response_str)

        def makefile(self, *_, **__):
            return self._file

    def __init__(self, response_data, modules):
        self._source = self.FakeSocket(response_data)
        self._response = HTTPResponse(self._source)
        self.modules = modules
        try:
            self._response.begin()
            self.status = self._response.status
            self.headers = dict(self._response.getheaders())
            self.content = self._response.read(len(response_data))
            self.content_type = "UNKNOWN"
        except:
            self.status = "EMPTY CONTENT"
            self.headers = {}
            self.content = ""
            self.content_type = "EMPTY"
        try:
            self.parse()
        except Exception as e:
            self.status = "ERROR PARSE"
            logger.info("ERROR PARSE")
            logger.exception(e.message, exc_info=sys.exc_info())
            self.content_type = "ERROR_PARSE"

    def parse(self):
        if self.headers:
            for module in self.modules:
                self.headers = module.process_headers(self.headers)
        if not self.content:
            return
        for module in self.modules:
            try:
                self.content, self.content_type = module.process_content(self.content, self.content_type)
            except Exception as e:
                logger.info("NAME " + module.name)
                logger.info("Content: {}".format(self.content))
                logger.info("Content_type: {}".format(self.content_type))
                logger.exception(e.message, exc_info=sys.exc_info())

    def get_serialized_status(self):
        return [str(self.status)]

    def get_serialized_headers(self):
        return json.dumps(self.headers, sort_keys=True, indent=4).splitlines()

    def get_serialized_content(self):
        return self.content.splitlines()
