import gzip
import json
import re

from sandbox import sdk2
from sandbox.projects.common.yabs.server.requestlog import iterate


def unpack_request_log(resource, re_to_match_request_id_in_request, split_re=r'\s'):
    path = str(sdk2.ResourceData(resource).path)
    with gzip.GzipFile(filename=path, mode='rb', mtime=0) as gz:
        requests = [req for req, _ in iterate(gz, split_re)]
    request_ids = [re.search(re_to_match_request_id_in_request, x).group(1) for x in requests]

    for i in range(len(requests)):
        try:
            json.dumps(requests[i])
        except:
            requests[i] = 'Failed to parse request. Look for it in request-data-log resource.'

    return dict(zip(request_ids, requests))
