import os
import logging
import subprocess

from sandbox import sdk2
from sandbox.common.types.misc import DnsType
import sandbox.projects.common.build.parameters as build_parameters
from sandbox.projects.yabs.ssr.util import run_command

from sandbox.projects.sandbox_ci.resources.generated import WebPcodeMicroPackage
from sandbox.projects.common.arcadia import sdk


CONTAINER_RESOURCE = 2893580981


class BuildWebPcodeMicroPackage(sdk2.Task):

    class Requirements(sdk2.Requirements):
        container_resource = CONTAINER_RESOURCE
        dns = DnsType.DNS64

    class Parameters(sdk2.Task.Parameters):
        description = "Creating WEB_PCODE_MICRO_PACKAGE resource"

        checkout_arcadia_from_url = build_parameters.ArcadiaUrl()

        with sdk2.parameters.Output:
            web_pcode_micro_package_resource = sdk2.parameters.Resource(
                'Resource with WEB_PCODE_MICRO_PACKAGE',
                resource_type=WebPcodeMicroPackage
            )

    def get_arcadia(self):
        url = self.Parameters.checkout_arcadia_from_url
        return sdk.mount_arc_path(url, use_arc_instead_of_aapi=True, fetch_all=False)

    def on_execute(self):
        def run_command_with_stderr(command):
            return run_command(command, stderr=subprocess.STDOUT)

        with self.get_arcadia() as local_arcadia_path:
            root_dir = os.getcwd()
            pcode_path = os.path.join(local_arcadia_path, 'frontend', 'services', 'pcode')
            logging.info(pcode_path)
            os.chdir(pcode_path)
            run_command_with_stderr('npm config set registry https://npm.yandex-team.ru')

            os.environ['TRENDBOX_JOB_ROOT'] = str(root_dir)
            os.environ["YENV"] = "production"
            run_command_with_stderr('npm install')
            run_command_with_stderr('npm run build')
            run_command_with_stderr('npm run artifacts')
            logging.info("Success build and artifacts")
            resource_path = os.path.join(root_dir, 'pcode-templates.tar.gz')
            web_pcode_micro_package_resource = sdk2.ResourceData(WebPcodeMicroPackage(
                self,
                'for shm',
                os.path.abspath(resource_path)
            )).ready()
            self.Parameters.web_pcode_micro_package_resource = web_pcode_micro_package_resource
