# import ast
# import json
import os
import sys
import yt.wrapper as yt
# from reducer import CompareDataReducer


def start_reduce_job(
    input_table,
    output_table,
    job_count,
    data_size_per_job,
    headers_to_replace,
    body_substitutes,
    base64_prefixes,
    entity_substitutes,
    logs_to_compare,
    log_fields_to_ignore,
    json_keys_to_delete,
    json_parsing_fields_re,
):
    yt.config['proxy']['url'] = 'hahn'
    yt.config['token'] = os.environ['YT_TOKEN']
    yt.config['pickling']['python_binary'] = '/skynet/python/bin/python'
    yt.config['pickling']['force_using_py_instead_of_pyc'] = True
    yt.config['pickling']['module_filter'] = (
        lambda module: hasattr(module, '__file__')
        and (not module.__file__.endswith('.so') or module.__file__.endswith('yson_lib.so'))
        and 'hashlib' not in getattr(module, '__name__', '')
        and 'hmac' not in getattr(module, '__name__', '')
    )

    # compare_data_reducer = CompareDataReducer(
    #     json.loads(headers_to_replace),
    #     json.loads(body_substitutes),
    #     json.loads(base64_prefixes),
    #     json.loads(entity_substitutes),
    #     json.loads(logs_to_compare),
    #     json.loads(log_fields_to_ignore),
    #     json.loads(json_keys_to_delete),
    #     json.loads(json_parsing_fields_re),
    # )
    # yt.run_reduce(
    #     compare_data_reducer,
    #     source_table=ast.literal_eval(input_table),
    #     destination_table=output_table,
    #     reduce_by=['RequestID'],
    #     spec={'data_size_per_job': int(data_size_per_job), 'job_count': int(job_count)},
    # )


def main():
    start_reduce_job(*sys.argv[1:])


if __name__ == '__main__':
    main()
