from sandbox import sdk2

from sandbox.projects.yabs.nanpu import BS_NANPU_DIFF_RESULT
from sandbox.projects.yabs.qa.tasks.BsNanpuSimpleShootTask import BsNanpuResponseDump
from sandbox.projects.yabs.qa.resource_types import YABS_REPORT_RESOURCE

from sandbox.projects.pcode.qa.resource_types import PCODE_JANPU_REQUEST_LOG_GZ
from sandbox.projects.pcode.qa.response_differ import modules


class DiffTaskParameters(sdk2.Task.Parameters):
    description = "Compare task for result of Janpu shoots"
    fail_task_if_has_diff = sdk2.parameters.Bool("For ci option to fail if has_diff", default=False)
    requestlog_resource = sdk2.parameters.Resource("Requestlog resource", resource_type=PCODE_JANPU_REQUEST_LOG_GZ)
    preshoot_result = sdk2.parameters.Resource("Preshoot result dump", resource_type=BsNanpuResponseDump)
    patched_shoot_result = sdk2.parameters.Resource("Patched shoot result dump", resource_type=BsNanpuResponseDump)
    template_resource = sdk2.parameters.Resource("Template resource", resource_type=YABS_REPORT_RESOURCE)

    bad_requests_ids = sdk2.parameters.List('Request IDs to ignore in comparison', default=[])

    with sdk2.parameters.Group('Addons for diff task'):
        headers_paint_module = modules.HeadersPaintModule.get_init_parameters_class()()

    with sdk2.parameters.Group('YT settings') as yt_settings:
        diff_table_prefix_path = sdk2.parameters.String("Result prefix yt table path",
                                                        default_value="//home/pcode/diff_tasks_results")
        yt_token = sdk2.parameters.YavSecretWithKey(
            'YT token name in Yav vault',
            required=True,
        )
        yt_cluster = sdk2.parameters.String("YT Cluster")
        yt_ttl = sdk2.parameters.Integer('TTL for YT table', default=7)
        yt_job_count = sdk2.parameters.Integer('YT job count for reduce operation', default=12)
        yt_data_size_per_job = sdk2.parameters.Integer('YT data size per job', default=32 * 1024 * 1024)

    with sdk2.parameters.Group('Common settings') as common_settings:
        ttl = sdk2.parameters.Integer('TTL for diff results', default=7)
        n_jobs = sdk2.parameters.Integer('Number of threads for report processing', default=8)

    with sdk2.parameters.Output:
        diff_table_path = sdk2.parameters.String('YT path to table with diff')
        report = sdk2.parameters.Resource('Report resource', resource_type=BS_NANPU_DIFF_RESULT)
