import base64
import re
import sys

from default_painting import PAINTING_MASK

from sandbox.projects.yabs.base_differ.base_response_differ import BaseResponseDiffer


class ResponseDiffer(BaseResponseDiffer):
    def __init__(
        self,
        headers_to_replace,
        body_substitutes,
        base64_prefixes,
        entity_substitutes,
        logs_to_compare,
        log_fields_to_ignore,
        json_keys_to_delete,
        json_parsing_fields_re,
        request_id,
    ):
        super(ResponseDiffer, self).__init__(headers_to_replace, body_substitutes, json_keys_to_delete, base64_prefixes)
        self.entity_substitutes = entity_substitutes
        self.logs_to_compare = logs_to_compare
        self.log_fields_to_ignore = log_fields_to_ignore
        self.json_parsing_fields_re = json_parsing_fields_re

        self.request_id = request_id

    def diff_response_data(self, response_pre, response_post):
        # todo fix
        if response_pre == '' or response_post == '':
            return False, '', '', '', '', '', ''

        try:
            status_diff, headers_diff, body_pre, body_post = super(ResponseDiffer, self).diff_response_data(response_pre, response_post)
            entities_diff, exts_diff, logs_diff, processing_type = self._bodies_diff(body_pre, body_post)
        except:
            print >>sys.stderr, self.request_id
            raise

        has_diff = len(status_diff) + len(headers_diff) + len(entities_diff) + len(exts_diff) + len(logs_diff) > 0

        return has_diff, status_diff, headers_diff, entities_diff, exts_diff, logs_diff, processing_type

    def _decompress_bodies(self, body_pre, body_post):
        return body_pre + body_post

    @staticmethod
    def _is_xml(body):
        return body.startswith('<?xml')

    @staticmethod
    def _is_html(body):
        return body.startswith('<!DOCTYPE html>')

    @staticmethod
    def _xml_diff_bad(xml_pre, xml_test):
        # todo fix
        serialized_pre = xml_pre.splitlines()
        serialized_test = xml_test.splitlines()
        return BaseResponseDiffer._string_lists_diff(serialized_pre, serialized_test)

    def _bodies_diff(self, body_pre, body_post):
        body_pre, body_post = self._decompress_bodies(body_pre, body_post)
        body_pre = self.apply_substituttes(body_pre, self.body_substitutes)
        body_post = self.apply_substituttes(body_post, self.body_substitutes)

        # TODO FIX
        if body_pre == body_post:
            return '', '', '', 'NONE'

        body_pre = base64.b64decode(body_pre).decode('utf-8')
        body_post = base64.b64decode(body_post).decode('utf-8')

        if self._is_xml(body_pre) != self._is_xml(body_post):
            # todo fix
            diff = self._xml_diff_bad(body_pre, '') if self._is_xml(body_pre) else self._xml_diff_bad('', body_post)
            return diff, '', '', 'XML_FAIL'

        if self._is_xml(body_pre):
            return self._xml_diff_bad(body_pre, body_post), '', '', 'XML_DIFF'

        pre_json, is_json_pre = self.try_to_json(body_pre)
        post_json, is_json_post = self.try_to_json(body_post)
        if is_json_post != is_json_pre:
            # todo fix
            diff = self._dict_diff(pre_json, {}) if is_json_pre else self._dict_diff({}, post_json)
            return diff, '', '', 'JSON_FAIL'

        if is_json_pre:
            return self._json_diff(pre_json, post_json), '', '', 'JSON_DIFF'

        if self._is_html(body_pre) != self._is_html(body_post):
            # todo fix
            return self._xml_diff_bad(body_pre, body_post), '', '', 'HTML_FAIL'

        if self._is_html(body_pre):
            return self._html_diff(body_pre, body_post), '', '', 'HTML_DIFF'

    def _processed_json(self, json_item):
        json_item = self.json_painter.apply_json_paints(json_item)
        for field in self.log_fields_to_ignore:
            if field not in json_item:
                continue
            json_item[field] = PAINTING_MASK
        return self._json2str(json_item)

    def _json_diff(self, pre_json, post_json):
        pre_json = self.json_painter.apply_json_paints(pre_json)
        post_json = self.json_painter.apply_json_paints(post_json)
        return self._dict_diff(pre_json, post_json)

    def _processed_html_with_json(self, html):
        for pattern in self.json_parsing_fields_re:
            list_of_json = re.findall(pattern, html)
            html_split = re.split(pattern, html)
            result_html = ""
            iter1, iter2 = 0, 0
            is_html_first = html.startswith(html_split[0])
            while iter1 < len(list_of_json) and iter2 < len(html_split):
                if is_html_first:
                    result_html += html_split[iter2]
                    result_html += self._processed_json(list_of_json[iter1])
                else:
                    result_html += self._processed_json(list_of_json[iter1])
                    result_html += html_split[iter2]
                iter1 += 1
                iter2 += 1
            while iter1 < len(list_of_json):
                result_html += self._processed_json(list_of_json[iter1])
                iter1 += 1
            while iter2 < len(html_split):
                result_html += html_split[iter2]
            html = result_html
        return html

    def _html_diff(self, html_pre, html_post):
        # todo add logic with base64prefixes
        html_pre = self._processed_html_with_json(html_pre)
        html_post = self._processed_html_with_json(html_post)
        return self._string_lists_diff(html_pre.splitlines(), html_post.splitlines())
