from sandbox.projects.pcode.qa.response_differ.response_parser import ResponseParser


class ResponseParseMapper(object):

    def __init__(self, modules):
        self.modules = modules

    def __call__(self, item):
        request_id = item[0]
        row = item[1]
        if row["Data"]:
            parsed_response = ResponseParser(row["Data"], modules=self.modules)
            return (request_id, {
                "RequestID": request_id,
                "Status": parsed_response.get_serialized_status(),
                "Headers": parsed_response.get_serialized_headers(),
                "Content": parsed_response.get_serialized_content(),
                "ContentType": [parsed_response.content_type],
            })
