import json

from sandbox import sdk2
import sandbox.common.types.client as ctc
from sandbox.projects.yabs.qa.ammo_module.requestlog.adapters.general.sandbox import (
    AmmoRequestlogModuleGeneralSandboxAdapter, parameters
)
from sandbox.projects.yabs.qa.dolbilo_module.simple.adapters.sandbox import DolbiloModuleSandboxAdapter
from sandbox.projects.yabs.qa.task_factory.simple_shoot_task import factory as simple_shoot_task_factory
from sandbox.projects.yabs.qa.yt_uploader_module.adapters.sandbox import ShootResultsYtUploaderGenericSandboxAdapter
from sandbox.projects.yabs.qa.tasks.BsNanpuSimpleShootTask import BsNanpuResponseDump

from sandbox.projects.pcode.qa.resource_types import PCODE_JANPU_REQUEST_LOG_GZ
from sandbox.projects.pcode.qa.mobile_ads_sdk.janpu_graph_sut.adapters.sandbox import JanpuGraphSUTSandboxAdapter


class AmmoRequestLogJanpuParameters(parameters.AmmoRequestlogGeneralParameters):
    requestlog_resource = sdk2.parameters.Resource('Requestlog resource',
                                                   resource_type=PCODE_JANPU_REQUEST_LOG_GZ, required=True)
    run_from_nirvana = sdk2.parameters.Bool('Task was launched from Nirvana', default_value=False)
    with run_from_nirvana.value[True]:
        nirvana_queryargs_update_dict = sdk2.parameters.String('Queryargs update dict', default_value='{}')
        nirvana_headers_update_dict = sdk2.parameters.String('Headers update dict', default_value='{}')
        nirvana_cookies_update_dict = sdk2.parameters.String('Cookies update dict', default_value='{}')


class AmmoRequestlogWithRepeatedQueryargsAdapter(AmmoRequestlogModuleGeneralSandboxAdapter):
    def __init__(self, parameters, task_instance):
        AmmoRequestlogModuleGeneralSandboxAdapter.__init__(
            self, parameters, task_instance, allow_repeated_queryargs=True
        )
        if self.parameters.run_from_nirvana:
            self.parameters.queryargs_update_dict = json.loads(self.parameters.nirvana_queryargs_update_dict)
            self.parameters.headers_update_dict = json.loads(self.parameters.nirvana_headers_update_dict)
            self.parameters.cookies_update_dict = json.loads(self.parameters.nirvana_cookies_update_dict)

    @staticmethod
    def get_init_parameters_class():
        return AmmoRequestLogJanpuParameters


class JanpuGraphSimpleShootTask(
    simple_shoot_task_factory(
        JanpuGraphSUTSandboxAdapter,
        AmmoRequestlogWithRepeatedQueryargsAdapter,
        DolbiloModuleSandboxAdapter,
        BsNanpuResponseDump,
        'JANPU_GRAPH',
        ShootResultsYtUploaderGenericSandboxAdapter,
    )
):
    class Requirements(sdk2.Task.Requirements):
        cores = 8
        ram = 16 * 1024
        client_tags = ctc.Tag.Group.LINUX & ctc.Tag.HDD

    def on_execute(self):
        super(JanpuGraphSimpleShootTask, self).on_execute()
        self.Parameters.output_yt_path = self.Context.output_yt_path
