from sandbox import sdk2

from sandbox.projects.pcode.qa.resource_types import JanpuPerfomanceResult, PcodeJanpuPerfAmmoGz

from sandbox.projects.yabs.qa.task_factory.perf_shoot_task import factory as perf_shoot_task_factory

from sandbox.projects.pcode.qa.mobile_ads_sdk.sut.adapters.sandbox import MobileAdsSdkSUTSandboxAdapter
from sandbox.projects.yabs.qa.dolbilo_module.simple.adapters.sandbox import DolbiloModuleSandboxAdapter
from sandbox.projects.yabs.qa.ammo_module.requestlog.adapters.general.sandbox import AmmoRequestlogModuleGeneralSandboxAdapter, \
    parameters
from sandbox.projects.yabs.base_bin_task import base_bin_task_parameters
from sandbox.projects.common.yabs.shm.shoot_session_aggregator.adapters.sandbox import SessionAggregatorSandboxAdapter

from sandbox.common.types.task import ReleaseStatus


class AmmoRequestLogJanpuParameters(parameters.AmmoRequestlogGeneralParameters):
    requestlog_resource = sdk2.parameters.Resource('Requestlog resource', resource_type=PcodeJanpuPerfAmmoGz, required=True)


class AmmoRequestLogJanpuModuleSandboxAdapter(AmmoRequestlogModuleGeneralSandboxAdapter):
    @staticmethod
    def get_init_parameters_class():
        return AmmoRequestLogJanpuParameters


def make_perf_shoot_task(is_2on1):
    return perf_shoot_task_factory(
        sut_module_adapter_class=MobileAdsSdkSUTSandboxAdapter,
        ammo_module_adapter_class=AmmoRequestLogJanpuModuleSandboxAdapter,
        shoot_module_adapter_class=DolbiloModuleSandboxAdapter,
        session_aggr_module_adapter_class=SessionAggregatorSandboxAdapter,
        dump_resource_class=JanpuPerfomanceResult,
        name_postfix='JANPU',
        is_2on1=is_2on1
    )


perf_1on1_task = make_perf_shoot_task(is_2on1=False)
perf_2on1_task = make_perf_shoot_task(is_2on1=True)

base_bin_task_bundle_parameters = base_bin_task_parameters(
    release_version_default=ReleaseStatus.STABLE,
    resource_attrs_default={"task_bundle": "pcode_janpu_service"},
)


class JanpuPerformance1On1(perf_1on1_task):
    class Parameters(perf_1on1_task.Parameters):
        kill_timeout = 60 * 30
        _base_bin_task_parameters = base_bin_task_bundle_parameters


class JanpuPerformance2On1(perf_2on1_task):
    class Parameters(perf_2on1_task.Parameters):
        kill_timeout = 60 * 30
        _base_bin_task_parameters = base_bin_task_bundle_parameters


class JanpuPerformanceParameters(sdk2.Task):
    class Parameters(perf_2on1_task.SeparateParameters):
        pass
